/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.util;

import co.elastic.apm.agent.objectpool.Recyclable;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.util.IOUtils;
import java.nio.Buffer;
import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;

public class BinaryHeaderMap
implements Recyclable,
Iterable<Entry> {
    public static final int MAXIMUM_HEADER_BUFFER_SIZE = 10240;
    private static final Logger logger = LoggerFactory.getLogger(BinaryHeaderMap.class);
    static final int INITIAL_CAPACITY = 10;
    private CharBuffer valueBuffer = CharBuffer.allocate(64);
    private final ArrayList<String> keys = new ArrayList(10);
    private int[] valueLengths = new int[10];
    private final NoGarbageIterator iterator = new NoGarbageIterator();

    public int size() {
        return this.keys.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean add(String key, @Nullable byte[] value) {
        boolean result;
        if (value == null) {
            this.addNewEntry(key, -1);
            return true;
        }
        int valuesPos = this.valueBuffer.position();
        CoderResult coderResult = IOUtils.decodeUtf8Bytes(value, this.valueBuffer);
        while (coderResult.isOverflow()) {
            ((Buffer)this.valueBuffer).limit(valuesPos);
            if (!this.enlargeBuffer()) {
                return false;
            }
            coderResult = IOUtils.decodeUtf8Bytes(value, this.valueBuffer);
        }
        if (coderResult.isError()) {
            ((Buffer)this.valueBuffer).limit(valuesPos);
            result = false;
        } else {
            this.addNewEntry(key, this.valueBuffer.position() - valuesPos);
            result = true;
        }
        return result;
    }

    private void addNewEntry(String key, int valueLength) {
        int size = this.keys.size();
        this.keys.add(key);
        if (size == this.valueLengths.length) {
            this.enlargeValueLengths();
        }
        this.valueLengths[size] = valueLength;
    }

    private boolean enlargeBuffer() {
        if (this.valueBuffer.capacity() == 10240) {
            logger.debug("Headers buffer reached its maximal size ({}) and cannot be further enlarged", (Object)10240);
            return false;
        }
        int newCapacity = Math.min(this.valueBuffer.capacity() * 2, 10240);
        CharBuffer newBuffer = CharBuffer.allocate(newCapacity);
        ((Buffer)this.valueBuffer).flip();
        newBuffer.put(this.valueBuffer);
        this.valueBuffer = newBuffer;
        return true;
    }

    private void enlargeValueLengths() {
        int[] newValueOffsets = new int[this.valueLengths.length * 2];
        System.arraycopy(this.valueLengths, 0, newValueOffsets, 0, this.valueLengths.length);
        this.valueLengths = newValueOffsets;
    }

    @Override
    public void resetState() {
        this.keys.clear();
        ((Buffer)this.valueBuffer).clear();
        this.iterator.reset();
    }

    @Override
    public Iterator<Entry> iterator() {
        this.iterator.reset();
        ((Buffer)this.valueBuffer).flip();
        return this.iterator;
    }

    public void copyFrom(BinaryHeaderMap other) {
        this.resetState();
        this.keys.addAll(other.keys);
        ((Buffer)other.valueBuffer).flip();
        if (this.valueBuffer.capacity() < other.valueBuffer.remaining()) {
            this.valueBuffer = CharBuffer.allocate(other.valueBuffer.remaining());
        }
        this.valueBuffer.put(other.valueBuffer);
        if (this.valueLengths.length < other.valueLengths.length) {
            this.valueLengths = new int[other.valueLengths.length];
        }
        System.arraycopy(other.valueLengths, 0, this.valueLengths, 0, other.valueLengths.length);
    }

    private class NoGarbageIterator
    implements Iterator<Entry> {
        int index = 0;
        int nextValueOffset = 0;
        final Entry entry = new Entry();

        private NoGarbageIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < BinaryHeaderMap.this.keys.size();
        }

        @Override
        public Entry next() {
            this.entry.reset();
            this.entry.key = (String)BinaryHeaderMap.this.keys.get(this.index);
            int valueLength = BinaryHeaderMap.this.valueLengths[this.index];
            if (valueLength < 0) {
                this.entry.setValue(null);
            } else {
                int thisValueOffset = this.nextValueOffset;
                this.nextValueOffset += BinaryHeaderMap.this.valueLengths[this.index];
                ((Buffer)BinaryHeaderMap.this.valueBuffer).limit(this.nextValueOffset);
                ((Buffer)BinaryHeaderMap.this.valueBuffer).position(thisValueOffset);
                this.entry.setValue(BinaryHeaderMap.this.valueBuffer);
            }
            ++this.index;
            return this.entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        void reset() {
            this.index = 0;
            this.nextValueOffset = 0;
            this.entry.reset();
        }
    }

    public static class Entry {
        @Nullable
        String key;
        CharBuffer value = CharBuffer.allocate(64);
        private boolean nullValue;

        public String getKey() {
            if (this.key == null) {
                throw new IllegalStateException("Key shouldn't be null. Make sure you don't read and write to this map concurrently");
            }
            return this.key;
        }

        @Nullable
        public CharSequence getValue() {
            return this.nullValue ? null : this.value;
        }

        void setValue(@Nullable CharBuffer valueBuffer) {
            if (valueBuffer == null) {
                this.nullValue = true;
            } else {
                this.nullValue = false;
                ((Buffer)this.value).clear();
                int remaining = valueBuffer.remaining();
                if (remaining > this.value.capacity()) {
                    if (this.value.capacity() < 1024) {
                        this.enlargeBuffer();
                    }
                    if (remaining > 1024) {
                        ((Buffer)valueBuffer).limit(valueBuffer.position() + 1024);
                    }
                }
                this.value.put(valueBuffer);
                ((Buffer)this.value).flip();
            }
        }

        void reset() {
            this.key = null;
            ((Buffer)this.value).clear();
        }

        private void enlargeBuffer() {
            CharBuffer newBuffer = CharBuffer.allocate(1024);
            ((Buffer)this.value).flip();
            newBuffer.put(this.value);
            this.value = newBuffer;
        }
    }
}

