/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.urlconnection;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.collections.WeakConcurrentProviderImpl;
import co.elastic.apm.agent.httpclient.HttpClientHelper;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.sdk.state.CallDepth;
import co.elastic.apm.agent.sdk.state.GlobalState;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakMap;
import co.elastic.apm.agent.urlconnection.UrlConnectionPropertyAccessor;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

@GlobalState
public abstract class HttpUrlConnectionInstrumentation
extends TracerAwareInstrumentation {
    public static final WeakMap<HttpURLConnection, Span> inFlightSpans = WeakConcurrentProviderImpl.createWeakSpanMap();
    public static final CallDepth callDepth = CallDepth.get(HttpUrlConnectionInstrumentation.class);

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("http-client", "urlconnection");
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("URLConnection").or(ElementMatchers.nameContains("UrlConnection"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.is(HttpURLConnection.class)).and(ElementMatchers.not(ElementMatchers.named("sun.net.www.protocol.https.HttpsURLConnectionImpl")));
    }

    public static class DisconnectInstrumentation
    extends HttpUrlConnectionInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("disconnect").and(ElementMatchers.takesArguments(0));
        }

        public static class AdviceClass {
            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
            public static void afterDisconnect(@Advice.This HttpURLConnection thiz, @Advice.Thrown @Nullable Throwable t, @Advice.FieldValue(value="responseCode") int responseCode) {
                Span span = inFlightSpans.remove(thiz);
                if (span != null) {
                    ((Span)((Span)span.captureException(t)).withOutcome(t != null ? Outcome.FAILURE : Outcome.SUCCESS)).end();
                }
            }
        }
    }

    public static class CreateSpanInstrumentation
    extends HttpUrlConnectionInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("connect").and(ElementMatchers.takesArguments(0)).or(ElementMatchers.named("getOutputStream").and(ElementMatchers.takesArguments(0))).or(ElementMatchers.named("getInputStream").and(ElementMatchers.takesArguments(0)));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Object enter(@Advice.This HttpURLConnection thiz, @Advice.FieldValue(value="connected") boolean connected, @Advice.Origin String signature) {
                boolean isNestedCall = callDepth.isNestedCallAndIncrement();
                AbstractSpan<?> parent = TracerAwareInstrumentation.tracer.getActive();
                if (parent == null) {
                    return null;
                }
                Span span = inFlightSpans.get(thiz);
                if (span == null && !connected) {
                    URL url = thiz.getURL();
                    span = HttpClientHelper.startHttpClientSpan(parent, thiz.getRequestMethod(), url.toString(), url.getProtocol(), url.getHost(), url.getPort());
                    if (!TraceContext.containsTraceContextTextHeaders(thiz, UrlConnectionPropertyAccessor.instance())) {
                        if (span != null) {
                            span.propagateTraceContext(thiz, UrlConnectionPropertyAccessor.instance());
                        } else {
                            parent.propagateTraceContext(thiz, UrlConnectionPropertyAccessor.instance());
                        }
                    }
                }
                if (!isNestedCall && span != null) {
                    span.activate();
                    return span;
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
            public static void exit(@Advice.This HttpURLConnection thiz, @Advice.Thrown @Nullable Throwable t, @Advice.FieldValue(value="responseCode") int responseCode, @Advice.Enter @Nullable Object spanObject, @Advice.Origin String signature) {
                callDepth.decrement();
                Span span = (Span)spanObject;
                if (span == null) {
                    return;
                }
                try {
                    if (responseCode != -1) {
                        inFlightSpans.remove(thiz);
                        if (!span.isFinished()) {
                            span.getContext().getHttp().withStatusCode(responseCode);
                            ((Span)span.captureException(t)).end();
                        }
                    } else if (t != null) {
                        inFlightSpans.remove(thiz);
                        if (!span.isFinished()) {
                            ((Span)((Span)span.captureException(t)).withOutcome(Outcome.FAILURE)).end();
                        }
                    } else {
                        inFlightSpans.put(thiz, span);
                    }
                }
                finally {
                    span.deactivate();
                }
            }
        }
    }
}

