/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.struts;

import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.context.web.WebConfiguration;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.struts.StrutsFrameworkUtils;
import co.elastic.apm.agent.util.TransactionNameUtils;
import javax.servlet.http.HttpServletRequest;
import net.bytebuddy.asm.Advice;

public class ExecuteOperationsAdvice {
    private static final WebConfiguration webConfig = GlobalTracer.requireTracerImpl().getConfig(WebConfiguration.class);

    @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
    public static void setTransactionName(@Advice.Argument(value=0) HttpServletRequest request, @Advice.Return boolean handled) {
        Transaction transaction = GlobalTracer.get().currentTransaction();
        if (!handled || transaction == null) {
            return;
        }
        StringBuilder transactionName = transaction.getAndOverrideName(100);
        if (transactionName != null) {
            TransactionNameUtils.setNameFromHttpRequestPath(request.getMethod(), request.getServletPath(), transactionName, webConfig.getUrlGroups());
            StrutsFrameworkUtils.setFrameworkNameAndVersion(transaction);
        }
    }
}

