/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.springwebmvc;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.springframework.web.servlet.view.AbstractView;

public class ViewRenderInstrumentation
extends TracerAwareInstrumentation {
    private static final String SPAN_TYPE = "template";
    private static final String SPAN_ACTION = "render";
    private static final String DISPATCHER_SERVLET_RENDER_METHOD = "View#render";
    private static Map<String, String> subTypeCache = new ConcurrentHashMap<String, String>();

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.springwebmvc.ViewRenderInstrumentation$ViewRenderAdviceService";
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("View");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("org.springframework.web.servlet.View"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named(SPAN_ACTION).and(ElementMatchers.takesArgument(0, ElementMatchers.named("java.util.Map"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("javax.servlet.http.HttpServletRequest"))).and(ElementMatchers.takesArgument(2, ElementMatchers.named("javax.servlet.http.HttpServletResponse")));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("spring-view-render");
    }

    public static class ViewRenderAdviceService {
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object beforeExecute(@Advice.This @Nullable Object thiz) {
            if (TracerAwareInstrumentation.tracer.getActive() == null) {
                return null;
            }
            AbstractSpan<?> parent = TracerAwareInstrumentation.tracer.getActive();
            String className = thiz.getClass().getName();
            Span span = (Span)((Span)parent.createSpan().withType(ViewRenderInstrumentation.SPAN_TYPE)).withSubtype(ViewRenderAdviceService.getSubtype(className)).withAction(ViewRenderInstrumentation.SPAN_ACTION).withName(ViewRenderInstrumentation.DISPATCHER_SERVLET_RENDER_METHOD);
            if (thiz instanceof AbstractView) {
                AbstractView view = (AbstractView)thiz;
                ((Span)span.appendToName(" ")).appendToName(view.getBeanName());
            }
            span.activate();
            return span;
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void afterExecute(@Advice.Enter @Nullable Object spanObj, @Advice.Thrown @Nullable Throwable t) {
            if (spanObj instanceof Span) {
                Span span = (Span)spanObj;
                ((Span)((Span)span.captureException(t)).deactivate()).end();
            }
        }

        public static String getSubtype(String className) {
            switch (className) {
                case "org.springframework.web.servlet.view.groovy.GroovyMarkupView": {
                    return "GroovyMarkup";
                }
                case "org.springframework.web.servlet.view.freemarker.FreeMarkerView": {
                    return "FreeMarker";
                }
                case "org.springframework.web.servlet.view.json.MappingJackson2JsonView": {
                    return "MappingJackson2Json";
                }
                case "de.neuland.jade4j.spring.view.JadeView": {
                    return "Jade";
                }
                case "org.springframework.web.servlet.view.InternalResourceView": {
                    return "InternalResource";
                }
                case "org.thymeleaf.spring4.view.ThymeleafView": {
                    return "Thymeleaf";
                }
            }
            String subType = (String)subTypeCache.get(className);
            if (subType != null) {
                return subType;
            }
            int indexOfLastDot = className.lastIndexOf(46);
            int indexOfView = className.lastIndexOf("View");
            subType = className.substring(indexOfLastDot + 1, indexOfView > indexOfLastDot ? indexOfView : className.length());
            if (subTypeCache.size() < 1000) {
                subTypeCache.put(className, subType);
            }
            return subType;
        }
    }
}

