/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.springwebmvc;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.context.web.WebConfiguration;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.util.TransactionNameUtils;
import co.elastic.apm.agent.util.VersionUtils;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.springframework.web.method.HandlerMethod;

public class SpringTransactionNameInstrumentation
extends TracerAwareInstrumentation {
    private static final String FRAMEWORK_NAME = "Spring Web MVC";

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.nameStartsWith("org.springframework.web.servlet").and(ElementMatchers.hasSuperType(ElementMatchers.named("org.springframework.web.servlet.HandlerAdapter"))).and(ElementMatchers.not(ElementMatchers.isInterface()));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("handle").and(ElementMatchers.returns(ElementMatchers.named("org.springframework.web.servlet.ModelAndView"))).and(ElementMatchers.takesArgument(0, ElementMatchers.named("javax.servlet.http.HttpServletRequest"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("javax.servlet.http.HttpServletResponse"))).and(ElementMatchers.takesArgument(2, Object.class));
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return CustomElementMatchers.classLoaderCanLoadClass("org.springframework.web.method.HandlerMethod");
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.springwebmvc.SpringTransactionNameInstrumentation$HandlerAdapterAdvice";
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singleton("spring-mvc");
    }

    public static class HandlerAdapterAdvice {
        private static final WebConfiguration webConfig = GlobalTracer.requireTracerImpl().getConfig(WebConfiguration.class);

        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static void setTransactionName(@Advice.Argument(value=0) HttpServletRequest request, @Advice.Argument(value=2) Object handler) {
            String methodName;
            String className;
            Transaction transaction = TracerAwareInstrumentation.tracer.currentTransaction();
            if (transaction == null) {
                return;
            }
            if (handler instanceof HandlerMethod) {
                HandlerMethod handlerMethod = (HandlerMethod)handler;
                className = handlerMethod.getBeanType().getSimpleName();
                methodName = handlerMethod.getMethod().getName();
            } else {
                className = handler.getClass().getSimpleName();
                methodName = null;
            }
            if (!className.isEmpty() && methodName != null) {
                TransactionNameUtils.setNameFromClassAndMethod(className, methodName, transaction.getAndOverrideName(100));
            } else if (webConfig.isUsePathAsName()) {
                TransactionNameUtils.setNameFromHttpRequestPath(request.getMethod(), request.getServletPath(), request.getPathInfo(), transaction.getAndOverrideName(11), webConfig.getUrlGroups());
            } else if (!className.isEmpty()) {
                TransactionNameUtils.setNameFromClassAndMethod(className, methodName, transaction.getAndOverrideName(11));
            } else {
                StringBuilder transactionName = transaction.getAndOverrideName(11);
                if (transactionName != null) {
                    transactionName.append(request.getMethod()).append(" unknown route");
                }
            }
            transaction.setFrameworkName(SpringTransactionNameInstrumentation.FRAMEWORK_NAME);
            transaction.setFrameworkVersion(VersionUtils.getVersion(HandlerMethod.class, "org.springframework", "spring-web"));
        }
    }
}

