/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.springwebmvc;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.configuration.ServiceInfo;
import co.elastic.apm.agent.servlet.ServletServiceNameHelper;
import co.elastic.apm.agent.servlet.adapter.JavaxServletApiAdapter;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.ServletContext;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.springframework.web.context.WebApplicationContext;

public class SpringServiceNameInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameEndsWith("ApplicationContext");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("org.springframework.web.context.WebApplicationContext"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("initPropertySources").and(ElementMatchers.takesArguments(0));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singletonList("spring-service-name");
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.springwebmvc.SpringServiceNameInstrumentation$SpringServiceNameAdvice";
    }

    public static class SpringServiceNameAdvice {
        private static final JavaxServletApiAdapter adapter = JavaxServletApiAdapter.get();

        @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
        public static void afterInitPropertySources(@Advice.This WebApplicationContext applicationContext) {
            ClassLoader servletClassloader;
            if (!ServiceInfo.autoDetected().isMultiServiceContainer()) {
                return;
            }
            ClassLoader classLoader = applicationContext.getClassLoader();
            ServiceInfo fromServletContext = ServiceInfo.empty();
            ServletContext servletContext = applicationContext.getServletContext();
            if (servletContext != null && (servletClassloader = adapter.getClassLoader(servletContext)) != null) {
                classLoader = servletClassloader;
                fromServletContext = ServletServiceNameHelper.detectServiceInfo(adapter, servletContext, servletClassloader);
            }
            ServiceInfo fromSpringApplicationNameProperty = ServiceInfo.of(applicationContext.getEnvironment().getProperty("spring.application.name", ""));
            ServiceInfo fromApplicationContextApplicationName = ServiceInfo.of(SpringServiceNameAdvice.removeLeadingSlash(applicationContext.getApplicationName()));
            TracerAwareInstrumentation.tracer.setServiceInfoForClassLoader(classLoader, fromSpringApplicationNameProperty.withFallback(fromServletContext).withFallback(fromApplicationContextApplicationName));
        }

        private static String removeLeadingSlash(String appName) {
            if (appName.startsWith("/")) {
                appName = appName.substring(1);
            }
            return appName;
        }
    }
}

