/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.springwebflux;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.httpserver.HttpServerHelper;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.Tracer;
import co.elastic.apm.agent.impl.context.Request;
import co.elastic.apm.agent.impl.context.Response;
import co.elastic.apm.agent.impl.context.web.ResultUtil;
import co.elastic.apm.agent.impl.context.web.WebConfiguration;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakConcurrent;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakMap;
import co.elastic.apm.agent.springwebflux.HeaderGetter;
import co.elastic.apm.agent.springwebflux.TransactionAwareSubscriber;
import co.elastic.apm.agent.springwebflux.WebfluxServletHelper;
import co.elastic.apm.agent.util.PotentiallyMultiValuedMap;
import co.elastic.apm.agent.util.TransactionNameUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.pattern.PathPattern;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

public class WebfluxHelper {
    private static final Logger log = LoggerFactory.getLogger(WebfluxHelper.class);
    public static final String TRANSACTION_ATTRIBUTE = WebfluxHelper.class.getName() + ".transaction";
    private static final String SUBSCRIBER_ATTRIBUTE = WebfluxHelper.class.getName() + ".wrapped_subscriber";
    private static final String SERVLET_TRANSACTION = WebfluxHelper.class.getName() + ".servlet_transaction";
    public static final String SSE_EVENT_CLASS = "org.springframework.http.codec.ServerSentEvent";
    private static final HeaderGetter HEADER_GETTER = new HeaderGetter();
    private static final CoreConfiguration coreConfig;
    private static final WebConfiguration webConfig;
    private static final HttpServerHelper serverHelper;
    private static final WeakMap<HandlerMethod, Boolean> ignoredHandlerMethods;

    @Nullable
    public static Transaction getOrCreateTransaction(Tracer tracer, ServerWebExchange exchange) {
        Transaction transaction = WebfluxServletHelper.getServletTransaction(exchange);
        boolean fromServlet = transaction != null;
        String path = exchange.getRequest().getPath().value();
        String userAgent = exchange.getRequest().getHeaders().getFirst("User-Agent");
        if (!fromServlet && !serverHelper.isRequestExcluded(path, userAgent)) {
            transaction = tracer.startChildTransaction(exchange.getRequest().getHeaders(), HEADER_GETTER, ServerWebExchange.class.getClassLoader());
        }
        if (transaction == null) {
            return null;
        }
        ((Transaction)transaction.withType("request")).activate();
        exchange.getAttributes().put(TRANSACTION_ATTRIBUTE, transaction);
        exchange.getAttributes().put(SERVLET_TRANSACTION, fromServlet);
        return transaction;
    }

    public static boolean isServletTransaction(ServerWebExchange exchange) {
        return Boolean.TRUE == exchange.getAttributes().get(SERVLET_TRANSACTION);
    }

    public static <T> Mono<T> wrapDispatcher(Mono<T> mono, Transaction transaction, ServerWebExchange exchange) {
        return WebfluxHelper.doWrap(mono, transaction, exchange, "webflux-dispatcher");
    }

    private static <T> Mono<T> doWrap(Mono<T> mono, final Transaction transaction, final ServerWebExchange exchange, final String description) {
        mono = mono.transform(Operators.liftPublisher((BiFunction)new BiFunction<Publisher, CoreSubscriber<? super T>, CoreSubscriber<? super T>>(){

            @Override
            public CoreSubscriber<? super T> apply(Publisher publisher, CoreSubscriber<? super T> subscriber) {
                log.trace("wrapping {} subscriber with transaction {}", (Object)description, (Object)transaction);
                TransactionAwareSubscriber wrappedSubscriber = new TransactionAwareSubscriber(subscriber, transaction, exchange, description);
                if (null != exchange.getAttributes().put(SUBSCRIBER_ATTRIBUTE, wrappedSubscriber)) {
                    log.debug("more than one wrapping subscriber in exchange");
                }
                return wrappedSubscriber;
            }
        }));
        return mono;
    }

    public static void endTransaction(@Nullable Throwable thrown, @Nullable Transaction transaction, ServerWebExchange exchange) {
        String path;
        int namePriority;
        if (transaction == null) {
            return;
        }
        Object attribute = exchange.getAttributes().remove(TRANSACTION_ATTRIBUTE);
        if (attribute != transaction) {
            return;
        }
        if (WebfluxHelper.ignoreTransaction(exchange)) {
            transaction.ignoreTransaction();
            transaction.end();
            return;
        }
        PathPattern pattern = (PathPattern)exchange.getAttribute(RouterFunctions.MATCHING_PATTERN_ATTRIBUTE);
        if (pattern != null) {
            namePriority = 100;
            path = pattern.getPatternString();
        } else {
            namePriority = 11;
            path = webConfig.isUsePathAsName() ? exchange.getRequest().getPath().value() : "unknown route";
        }
        TransactionNameUtils.setNameFromHttpRequestPath(exchange.getRequest().getMethodValue(), path, transaction.getAndOverrideName(namePriority, false), webConfig.getUrlGroups());
        if (!transaction.getContext().getRequest().hasContent()) {
            WebfluxHelper.fillRequest(transaction, exchange);
            WebfluxHelper.fillResponse(transaction, exchange);
        }
        transaction.captureException(thrown);
        if (!WebfluxHelper.isServletTransaction(exchange)) {
            transaction.end();
        }
    }

    private static boolean ignoreTransaction(ServerWebExchange exchange) {
        Object attribute = exchange.getAttribute(HandlerMapping.BEST_MATCHING_HANDLER_ATTRIBUTE);
        if (!(attribute instanceof HandlerMethod)) {
            return false;
        }
        HandlerMethod handlerMethod = (HandlerMethod)attribute;
        Boolean ignoredCache = ignoredHandlerMethods.get(handlerMethod);
        if (ignoredCache != null) {
            return ignoredCache;
        }
        Type returnType = handlerMethod.getMethod().getGenericReturnType();
        if (!(returnType instanceof ParameterizedType)) {
            ignoredHandlerMethods.put(handlerMethod, false);
            return false;
        }
        Type[] genReturnTypes = ((ParameterizedType)returnType).getActualTypeArguments();
        for (int i = 0; i < genReturnTypes.length; ++i) {
            if (!genReturnTypes[i].getTypeName().startsWith(SSE_EVENT_CLASS)) continue;
            ignoredHandlerMethods.put(handlerMethod, true);
            return true;
        }
        ignoredHandlerMethods.put(handlerMethod, false);
        return false;
    }

    private static void fillRequest(Transaction transaction, ServerWebExchange exchange) {
        ServerHttpRequest serverRequest = exchange.getRequest();
        Request request = transaction.getContext().getRequest();
        request.withMethod(serverRequest.getMethodValue());
        InetSocketAddress remoteAddress = serverRequest.getRemoteAddress();
        if (remoteAddress != null && remoteAddress.getAddress() != null) {
            request.getSocket().withRemoteAddress(remoteAddress.getAddress().getHostAddress());
        }
        request.getUrl().fillFrom(serverRequest.getURI());
        if (coreConfig.isCaptureHeaders()) {
            WebfluxHelper.copyHeaders(serverRequest.getHeaders(), request.getHeaders());
            WebfluxHelper.copyCookies((MultiValueMap<String, HttpCookie>)serverRequest.getCookies(), request.getCookies());
        }
    }

    private static void fillResponse(Transaction transaction, ServerWebExchange exchange) {
        ServerHttpResponse serverResponse = exchange.getResponse();
        HttpStatus statusCode = serverResponse.getStatusCode();
        int status = statusCode != null ? statusCode.value() : 200;
        transaction.withResultIfUnset(ResultUtil.getResultByHttpStatus(status));
        Response response = transaction.getContext().getResponse();
        if (coreConfig.isCaptureHeaders()) {
            WebfluxHelper.copyHeaders(serverResponse.getHeaders(), response.getHeaders());
        }
        response.withFinished(true).withStatusCode(status);
    }

    private static void copyHeaders(HttpHeaders source, PotentiallyMultiValuedMap destination) {
        for (Map.Entry header : source.entrySet()) {
            for (String value : (List)header.getValue()) {
                destination.add((String)header.getKey(), value);
            }
        }
    }

    private static void copyCookies(MultiValueMap<String, HttpCookie> source, PotentiallyMultiValuedMap destination) {
        for (Map.Entry cookie : source.entrySet()) {
            for (HttpCookie value : (List)cookie.getValue()) {
                destination.add(value.getName(), value.getValue());
            }
        }
    }

    static {
        ignoredHandlerMethods = WeakConcurrent.buildMap();
        coreConfig = GlobalTracer.requireTracerImpl().getConfig(CoreConfiguration.class);
        webConfig = GlobalTracer.requireTracerImpl().getConfig(WebConfiguration.class);
        serverHelper = new HttpServerHelper(webConfig);
    }
}

