/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet.servicename;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.servlet.AbstractServletInstrumentation;
import co.elastic.apm.agent.servlet.Constants;
import co.elastic.apm.agent.servlet.ServletServiceNameHelper;
import co.elastic.apm.agent.servlet.adapter.JakartaServletApiAdapter;
import co.elastic.apm.agent.servlet.adapter.JavaxServletApiAdapter;
import jakarta.servlet.ServletContext;
import java.util.Set;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class ServletContainerInitializerServiceNameInstrumentation
extends AbstractServletInstrumentation {
    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Initializer");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.namedOneOf("javax.servlet.ServletContainerInitializer", "jakarta.servlet.ServletContainerInitializer")));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("onStartup").and(ElementMatchers.takesArguments(2)).and(ElementMatchers.takesArgument(0, Set.class)).and(ElementMatchers.takesArgument(1, ElementMatchers.nameEndsWith("ServletContext")));
    }

    public static class JakartaInitServiceNameInstrumentation
    extends ServletContainerInitializerServiceNameInstrumentation {
        @Override
        public Constants.ServletImpl getImplConstants() {
            return Constants.ServletImpl.JAKARTA;
        }

        public static class AdviceClass {
            private static final JakartaServletApiAdapter adapter = JakartaServletApiAdapter.get();

            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void onEnter(@Advice.Argument(value=1) @Nullable Object servletContext) {
                if (servletContext instanceof ServletContext) {
                    ServletServiceNameHelper.determineServiceName(adapter, (ServletContext)servletContext, TracerAwareInstrumentation.tracer);
                }
            }
        }
    }

    public static class JavaxInitServiceNameInstrumentation
    extends ServletContainerInitializerServiceNameInstrumentation {
        @Override
        public Constants.ServletImpl getImplConstants() {
            return Constants.ServletImpl.JAVAX;
        }

        public static class AdviceClass {
            private static final JavaxServletApiAdapter adapter = JavaxServletApiAdapter.get();

            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void onEnter(@Advice.Argument(value=1) @Nullable Object servletContext) {
                if (servletContext instanceof javax.servlet.ServletContext) {
                    ServletServiceNameHelper.determineServiceName(adapter, (javax.servlet.ServletContext)servletContext, TracerAwareInstrumentation.tracer);
                }
            }
        }
    }
}

