/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet;

import co.elastic.apm.agent.configuration.ServiceInfo;
import co.elastic.apm.agent.impl.Tracer;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.sdk.state.GlobalState;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakConcurrent;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakMap;
import co.elastic.apm.agent.servlet.adapter.ServletContextAdapter;
import java.io.InputStream;
import java.util.jar.Manifest;
import javax.annotation.Nullable;

@GlobalState
public class ServletServiceNameHelper {
    public static final WeakMap<ClassLoader, Boolean> nameInitialized = WeakConcurrent.buildMap();
    private static final Logger logger = LoggerFactory.getLogger(ServletServiceNameHelper.class);

    public static <ServletContext> void determineServiceName(ServletContextAdapter<ServletContext> adapter, @Nullable ServletContext servletContext, Tracer tracer) {
        if (servletContext == null) {
            return;
        }
        ClassLoader servletContextClassLoader = null;
        if (!servletContext.getClass().getName().startsWith("org.apache.sling")) {
            servletContextClassLoader = adapter.getClassLoader(servletContext);
        }
        if (servletContextClassLoader == null || nameInitialized.putIfAbsent(servletContextClassLoader, Boolean.TRUE) != null) {
            return;
        }
        ServiceInfo serviceInfo = ServletServiceNameHelper.detectServiceInfo(adapter, servletContext, servletContextClassLoader);
        tracer.setServiceInfoForClassLoader(servletContextClassLoader, serviceInfo);
    }

    public static <ServletContext> ServiceInfo detectServiceInfo(ServletContextAdapter<ServletContext> adapter, ServletContext servletContext, ClassLoader servletContextClassLoader) {
        String servletContextName = adapter.getServletContextName(servletContext);
        String contextPath = adapter.getContextPath(servletContext);
        if (logger.isDebugEnabled()) {
            logger.debug("Inferring service name for class loader [{}] based on servlet context path `{}` and request context path `{}`", servletContextClassLoader, servletContextName, contextPath);
        }
        ServiceInfo fromWarManifest = ServiceInfo.fromManifest(ServletServiceNameHelper.getManifest(adapter, servletContext));
        ServiceInfo fromContextName = ServiceInfo.empty();
        if (!("application".equals(servletContextName) || "".equals(servletContextName) || "/".equals(servletContextName))) {
            fromContextName = ServiceInfo.of(servletContextName);
        }
        ServiceInfo fromContextPath = ServiceInfo.empty();
        if (contextPath != null && !contextPath.isEmpty()) {
            fromContextPath = ServiceInfo.of(contextPath.substring(1));
        }
        return fromWarManifest.withFallback(fromContextName).withFallback(fromContextPath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static <ServletContext> Manifest getManifest(ServletContextAdapter<ServletContext> adapter, ServletContext servletContext) {
        try (InputStream manifestStream = adapter.getResourceAsStream(servletContext, "/META-INF/MANIFEST.MF");){
            if (manifestStream == null) {
                Manifest manifest2 = null;
                return manifest2;
            }
            Manifest manifest = new Manifest(manifestStream);
            return manifest;
        }
        catch (Exception e) {
            return null;
        }
    }

    static void clearServiceNameCache() {
        nameInitialized.clear();
    }
}

