/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.Scope;
import co.elastic.apm.agent.impl.context.Request;
import co.elastic.apm.agent.impl.context.Response;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.sdk.state.GlobalVariables;
import co.elastic.apm.agent.sdk.weakconcurrent.DetachedThreadLocal;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakConcurrent;
import co.elastic.apm.agent.servlet.RequestDispatcherSpanType;
import co.elastic.apm.agent.servlet.ServletServiceNameHelper;
import co.elastic.apm.agent.servlet.ServletTransactionHelper;
import co.elastic.apm.agent.servlet.adapter.ServletApiAdapter;
import co.elastic.apm.agent.util.TransactionNameUtils;
import java.security.Principal;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class ServletApiAdvice {
    private static final String FRAMEWORK_NAME = "Servlet API";
    static final String SPAN_TYPE = "servlet";
    static final String SPAN_SUBTYPE = "request-dispatcher";
    private static final ServletTransactionHelper servletTransactionHelper = new ServletTransactionHelper(GlobalTracer.requireTracerImpl());
    private static final DetachedThreadLocal<Boolean> excluded = GlobalVariables.get(ServletApiAdvice.class, "excluded", WeakConcurrent.buildThreadLocal());
    private static final DetachedThreadLocal<Object> servletPathTL = GlobalVariables.get(ServletApiAdvice.class, "servletPath", WeakConcurrent.buildThreadLocal());
    private static final DetachedThreadLocal<Object> pathInfoTL = GlobalVariables.get(ServletApiAdvice.class, "pathInfo", WeakConcurrent.buildThreadLocal());
    private static final List<String> requestExceptionAttributes = Arrays.asList("javax.servlet.error.exception", "jakarta.servlet.error.exception", "exception", "org.springframework.web.servlet.DispatcherServlet.EXCEPTION", "co.elastic.apm.exception");

    @Nullable
    public static <HttpServletRequest, HttpServletResponse, ServletContext, ServletContextEvent, FilterConfig, ServletConfig> Object onServletEnter(ServletApiAdapter<HttpServletRequest, HttpServletResponse, ServletContext, ServletContextEvent, FilterConfig, ServletConfig> adapter, Object servletRequest) {
        AbstractSpan<?> parent;
        ElasticApmTracer tracer = GlobalTracer.getTracerImpl();
        if (tracer == null) {
            return null;
        }
        Object httpServletRequest = adapter.asHttpServletRequest(servletRequest);
        if (httpServletRequest == null) {
            return null;
        }
        AbstractSpan ret = null;
        Transaction transactionAttr = (Transaction)adapter.getAttribute(httpServletRequest, ServletTransactionHelper.TRANSACTION_ATTRIBUTE);
        if (tracer.currentTransaction() == null && transactionAttr != null) {
            return transactionAttr.activateInScope();
        }
        if (!tracer.isRunning()) {
            return null;
        }
        CoreConfiguration coreConfig = tracer.getConfig(CoreConfiguration.class);
        if (adapter.isRequestDispatcherType(httpServletRequest)) {
            if (Boolean.TRUE == excluded.get()) {
                return null;
            }
            ServletServiceNameHelper.determineServiceName(adapter, adapter.getServletContext(httpServletRequest), tracer);
            Transaction transaction = servletTransactionHelper.createAndActivateTransaction(adapter, adapter, httpServletRequest);
            if (transaction == null) {
                excluded.set(Boolean.TRUE);
                return null;
            }
            Request req = transaction.getContext().getRequest();
            if (transaction.isSampled() && coreConfig.isCaptureHeaders()) {
                adapter.handleCookies(req, httpServletRequest);
                Enumeration<String> headerNames = adapter.getRequestHeaderNames(httpServletRequest);
                if (headerNames != null) {
                    while (headerNames.hasMoreElements()) {
                        String headerName = headerNames.nextElement();
                        req.addHeader(headerName, adapter.getRequestHeaders(httpServletRequest, headerName));
                    }
                }
            }
            transaction.setFrameworkName(FRAMEWORK_NAME);
            servletTransactionHelper.fillRequestContext(transaction, adapter.getProtocol(httpServletRequest), adapter.getMethod(httpServletRequest), adapter.isSecure(httpServletRequest), adapter.getScheme(httpServletRequest), adapter.getServerName(httpServletRequest), adapter.getServerPort(httpServletRequest), adapter.getRequestURI(httpServletRequest), adapter.getQueryString(httpServletRequest), adapter.getRemoteAddr(httpServletRequest), adapter.getHeader(httpServletRequest, "Content-Type"));
            ret = transaction;
        } else if (!adapter.isAsyncDispatcherType(httpServletRequest) && coreConfig.isInstrumentationEnabled("servlet-api-dispatch") && (parent = tracer.getActive()) != null) {
            Object servletPath = null;
            Object pathInfo = null;
            RequestDispatcherSpanType spanType = null;
            if (adapter.isForwardDispatcherType(httpServletRequest)) {
                spanType = RequestDispatcherSpanType.FORWARD;
                servletPath = adapter.getServletPath(httpServletRequest);
                pathInfo = adapter.getPathInfo(httpServletRequest);
            } else if (adapter.isIncludeDispatcherType(httpServletRequest)) {
                spanType = RequestDispatcherSpanType.INCLUDE;
                servletPath = adapter.getIncludeServletPathAttribute(httpServletRequest);
                pathInfo = adapter.getIncludePathInfoAttribute(httpServletRequest);
            } else if (adapter.isErrorDispatcherType(httpServletRequest)) {
                spanType = RequestDispatcherSpanType.ERROR;
                servletPath = adapter.getServletPath(httpServletRequest);
            }
            if (spanType != null && (ServletApiAdvice.areNotEqual(servletPathTL.get(), servletPath) || ServletApiAdvice.areNotEqual(pathInfoTL.get(), pathInfo))) {
                ret = ((Span)((Span)parent.createSpan().appendToName(spanType.getNamePrefix())).withAction(spanType.getAction()).withType(SPAN_TYPE)).withSubtype(SPAN_SUBTYPE);
                if (servletPath != null) {
                    ret.appendToName(servletPath.toString());
                    servletPathTL.set(servletPath);
                }
                if (pathInfo != null) {
                    ret.appendToName(pathInfo.toString());
                    pathInfoTL.set(pathInfo);
                }
                ret.activate();
            }
        }
        return ret;
    }

    public static <HttpServletRequest, HttpServletResponse, ServletContext, ServletContextEvent, FilterConfig, ServletConfig> void onExitServlet(ServletApiAdapter<HttpServletRequest, HttpServletResponse, ServletContext, ServletContextEvent, FilterConfig, ServletConfig> adapter, Object servletRequest, Object servletResponse, @Nullable Object transactionOrScopeOrSpan, @Nullable Throwable t, Object thiz) {
        Transaction currentTransaction;
        ElasticApmTracer tracer = GlobalTracer.getTracerImpl();
        if (tracer == null) {
            return;
        }
        Transaction transaction = null;
        Scope scope = null;
        Span span = null;
        if (transactionOrScopeOrSpan instanceof Transaction) {
            transaction = (Transaction)transactionOrScopeOrSpan;
        } else if (transactionOrScopeOrSpan instanceof Scope) {
            scope = (Scope)transactionOrScopeOrSpan;
        } else if (transactionOrScopeOrSpan instanceof Span) {
            span = (Span)transactionOrScopeOrSpan;
        }
        excluded.remove();
        if (scope != null) {
            scope.close();
        }
        Object httpServletRequest = adapter.asHttpServletRequest(servletRequest);
        Object httpServletResponse = adapter.asHttpServletResponse(servletResponse);
        if (adapter.isInstanceOfHttpServlet(thiz) && httpServletRequest != null && (currentTransaction = tracer.currentTransaction()) != null) {
            TransactionNameUtils.setTransactionNameByServletClass(adapter.getMethod(httpServletRequest), thiz.getClass(), currentTransaction.getAndOverrideName(10));
            Principal userPrincipal = adapter.getUserPrincipal(httpServletRequest);
            ServletTransactionHelper.setUsernameIfUnset(userPrincipal != null ? userPrincipal.getName() : null, currentTransaction.getContext());
        }
        if (transaction != null && httpServletRequest != null && httpServletResponse != null) {
            if (adapter.getHttpAttribute(httpServletRequest, ServletTransactionHelper.ASYNC_ATTRIBUTE) != null) {
                transaction.deactivate();
            } else {
                if (transaction.isSampled() && tracer.getConfig(CoreConfiguration.class).isCaptureHeaders()) {
                    Response resp = transaction.getContext().getResponse();
                    for (String headerName : adapter.getHeaderNames(httpServletResponse)) {
                        resp.addHeader(headerName, adapter.getHeaders(httpServletResponse, headerName));
                    }
                }
                String contentTypeHeader = adapter.getHeader(httpServletRequest, "Content-Type");
                Map<String, String[]> parameterMap = transaction.isSampled() && servletTransactionHelper.captureParameters(adapter.getMethod(httpServletRequest), contentTypeHeader) ? adapter.getParameterMap(httpServletRequest) : null;
                Throwable t2 = null;
                boolean overrideStatusCodeOnThrowable = true;
                if (t == null) {
                    int size = requestExceptionAttributes.size();
                    for (int i = 0; i < size; ++i) {
                        String attributeName = requestExceptionAttributes.get(i);
                        Object throwable = adapter.getHttpAttribute(httpServletRequest, attributeName);
                        if (!(throwable instanceof Throwable)) continue;
                        t2 = (Throwable)throwable;
                        if (attributeName.equals("javax.servlet.error.exception") || attributeName.equals("jakarta.servlet.error.exception")) break;
                        overrideStatusCodeOnThrowable = false;
                        break;
                    }
                }
                servletTransactionHelper.onAfter(transaction, t == null ? t2 : t, adapter.isCommitted(httpServletResponse), adapter.getStatus(httpServletResponse), overrideStatusCodeOnThrowable, adapter.getMethod(httpServletRequest), parameterMap, adapter.getServletPath(httpServletRequest), adapter.getPathInfo(httpServletRequest), contentTypeHeader, true);
            }
        }
        if (span != null) {
            servletPathTL.remove();
            pathInfoTL.remove();
            ((Span)((Span)((Span)span.captureException(t)).withOutcome(t != null ? Outcome.FAILURE : Outcome.SUCCESS)).deactivate()).end();
        }
    }

    private static boolean areNotEqual(@Nullable Object first, @Nullable Object second) {
        if (first == null) {
            return second != null;
        }
        return !first.equals(second);
    }
}

