/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet;

import co.elastic.apm.agent.sdk.state.CallDepth;
import co.elastic.apm.agent.servlet.AbstractServletInstrumentation;
import java.util.Arrays;
import java.util.Collection;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class RequestStreamRecordingInstrumentation
extends AbstractServletInstrumentation {
    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Request");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(this.getImplConstants().requestClassMatcher()).and(ElementMatchers.not(ElementMatchers.isInterface()));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("getInputStream").and(ElementMatchers.returns(ElementMatchers.hasSuperType(this.getImplConstants().servletInputStreamClassMatcher())));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("servlet-api", "servlet-input-stream");
    }

    public static class GetInputStreamAdvice {
        private static final CallDepth callDepth = CallDepth.get(GetInputStreamAdvice.class);

        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static void onReadEnter(@Advice.This Object thiz) {
            callDepth.increment();
        }
    }
}

