/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.sdk.state.CallDepth;
import co.elastic.apm.agent.servlet.Constants;
import co.elastic.apm.agent.servlet.RequestStreamRecordingInstrumentation;
import co.elastic.apm.agent.servlet.helper.JakartaRecordingServletInputStreamWrapper;
import jakarta.servlet.ServletInputStream;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;

public class JakartaRequestStreamRecordingInstrumentation
extends RequestStreamRecordingInstrumentation {
    @Override
    public Constants.ServletImpl getImplConstants() {
        return Constants.ServletImpl.JAKARTA;
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.servlet.JakartaRequestStreamRecordingInstrumentation$GetInputStreamAdvice";
    }

    public static class GetInputStreamAdvice {
        private static final CallDepth callDepth = CallDepth.get(GetInputStreamAdvice.class);

        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static void onReadEnter(@Advice.This Object thiz) {
            callDepth.increment();
        }

        @Nullable
        @Advice.AssignReturned.ToReturned
        @Advice.OnMethodExit(suppress=Throwable.class, inline=false, onThrowable=Throwable.class)
        public static ServletInputStream afterGetInputStream(@Advice.Return @Nullable ServletInputStream inputStream) {
            if (callDepth.isNestedCallAndDecrement() || inputStream == null) {
                return inputStream;
            }
            Transaction transaction = TracerAwareInstrumentation.tracer.currentTransaction();
            if (transaction != null && transaction.getContext().getRequest().getBodyBuffer() != null) {
                return new JakartaRecordingServletInputStreamWrapper(transaction.getContext().getRequest(), inputStream);
            }
            return inputStream;
        }
    }
}

