/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.sdk.logging;

import co.elastic.apm.agent.sdk.logging.ILoggerFactory;
import co.elastic.apm.agent.sdk.logging.Logger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.annotation.Nullable;

public class LoggerFactory {
    private static volatile ILoggerFactory iLoggerFactory;

    public static void initialize(ILoggerFactory iLoggerFactory) {
        LoggerFactory.iLoggerFactory = iLoggerFactory;
    }

    public static Logger getLogger(String name) {
        Logger logger = LoggerFactory.getLoggerFromFactory(name);
        return logger != null ? logger : new LazyInitLogger(name);
    }

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    @Nullable
    private static Logger getLoggerFromFactory(final String name) {
        if (iLoggerFactory == null) {
            return null;
        }
        Logger logger = AccessController.doPrivileged(new PrivilegedAction<Logger>(){

            @Override
            public Logger run() {
                return iLoggerFactory.getLogger(name);
            }
        });
        return logger != null ? logger : NoopLogger.INSTANCE;
    }

    static class NoopLogger
    implements Logger {
        static final NoopLogger INSTANCE = new NoopLogger();

        private NoopLogger() {
        }

        @Override
        public String getName() {
            return "null";
        }

        @Override
        public boolean isTraceEnabled() {
            return false;
        }

        @Override
        public void trace(String msg) {
        }

        @Override
        public void trace(String format, Object arg) {
        }

        @Override
        public void trace(String format, Object arg1, Object arg2) {
        }

        @Override
        public void trace(String format, Object ... arguments) {
        }

        @Override
        public void trace(String msg, Throwable t) {
        }

        @Override
        public boolean isDebugEnabled() {
            return false;
        }

        @Override
        public void debug(String msg) {
        }

        @Override
        public void debug(String format, Object arg) {
        }

        @Override
        public void debug(String format, Object arg1, Object arg2) {
        }

        @Override
        public void debug(String format, Object ... arguments) {
        }

        @Override
        public void debug(String msg, Throwable t) {
        }

        @Override
        public boolean isInfoEnabled() {
            return false;
        }

        @Override
        public void info(String msg) {
        }

        @Override
        public void info(String format, Object arg) {
        }

        @Override
        public void info(String format, Object arg1, Object arg2) {
        }

        @Override
        public void info(String format, Object ... arguments) {
        }

        @Override
        public void info(String msg, Throwable t) {
        }

        @Override
        public boolean isWarnEnabled() {
            return false;
        }

        @Override
        public void warn(String msg) {
        }

        @Override
        public void warn(String format, Object arg) {
        }

        @Override
        public void warn(String format, Object ... arguments) {
        }

        @Override
        public void warn(String format, Object arg1, Object arg2) {
        }

        @Override
        public void warn(String msg, Throwable t) {
        }

        @Override
        public boolean isErrorEnabled() {
            return false;
        }

        @Override
        public void error(String msg) {
        }

        @Override
        public void error(String format, Object arg) {
        }

        @Override
        public void error(String format, Object arg1, Object arg2) {
        }

        @Override
        public void error(String format, Object ... arguments) {
        }

        @Override
        public void error(String msg, Throwable t) {
        }
    }

    static class LazyInitLogger
    implements Logger {
        private final String name;
        private volatile Logger delegate = null;

        LazyInitLogger(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        Logger getDelegate() {
            if (this.delegate != null) {
                return this.delegate;
            }
            this.delegate = LoggerFactory.getLoggerFromFactory(this.name);
            return this.delegate != null ? this.delegate : NoopLogger.INSTANCE;
        }

        @Override
        public boolean isTraceEnabled() {
            return this.getDelegate().isTraceEnabled();
        }

        @Override
        public void trace(String msg) {
            this.getDelegate().trace(msg);
        }

        @Override
        public void trace(String format, Object arg) {
            this.getDelegate().trace(format, arg);
        }

        @Override
        public void trace(String format, Object arg1, Object arg2) {
            this.getDelegate().trace(format, arg1, arg2);
        }

        @Override
        public void trace(String format, Object ... arguments) {
            this.getDelegate().trace(format, arguments);
        }

        @Override
        public void trace(String msg, Throwable t) {
            this.getDelegate().trace(msg, t);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.getDelegate().isDebugEnabled();
        }

        @Override
        public void debug(String msg) {
            this.getDelegate().debug(msg);
        }

        @Override
        public void debug(String format, Object arg) {
            this.getDelegate().debug(format, arg);
        }

        @Override
        public void debug(String format, Object arg1, Object arg2) {
            this.getDelegate().debug(format, arg1, arg2);
        }

        @Override
        public void debug(String format, Object ... arguments) {
            this.getDelegate().debug(format, arguments);
        }

        @Override
        public void debug(String msg, Throwable t) {
            this.getDelegate().debug(msg, t);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.getDelegate().isInfoEnabled();
        }

        @Override
        public void info(String msg) {
            this.getDelegate().info(msg);
        }

        @Override
        public void info(String format, Object arg) {
            this.getDelegate().info(format, arg);
        }

        @Override
        public void info(String format, Object arg1, Object arg2) {
            this.getDelegate().info(format, arg1, arg2);
        }

        @Override
        public void info(String format, Object ... arguments) {
            this.getDelegate().info(format, arguments);
        }

        @Override
        public void info(String msg, Throwable t) {
            this.getDelegate().info(msg, t);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.getDelegate().isWarnEnabled();
        }

        @Override
        public void warn(String msg) {
            this.getDelegate().warn(msg);
        }

        @Override
        public void warn(String format, Object arg) {
            this.getDelegate().warn(format, arg);
        }

        @Override
        public void warn(String format, Object ... arguments) {
            this.getDelegate().warn(format, arguments);
        }

        @Override
        public void warn(String format, Object arg1, Object arg2) {
            this.getDelegate().warn(format, arg1, arg2);
        }

        @Override
        public void warn(String msg, Throwable t) {
            this.getDelegate().warn(msg, t);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.getDelegate().isErrorEnabled();
        }

        @Override
        public void error(String msg) {
            this.getDelegate().error(msg);
        }

        @Override
        public void error(String format, Object arg) {
            this.getDelegate().error(format, arg);
        }

        @Override
        public void error(String format, Object arg1, Object arg2) {
            this.getDelegate().error(format, arg1, arg2);
        }

        @Override
        public void error(String format, Object ... arguments) {
            this.getDelegate().error(format, arguments);
        }

        @Override
        public void error(String msg, Throwable t) {
            this.getDelegate().error(msg, t);
        }
    }
}

