/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.scalaconcurrent;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.collections.WeakConcurrentProviderImpl;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakMap;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class FutureInstrumentation
extends TracerAwareInstrumentation {
    public static final WeakMap<Object, AbstractSpan<?>> promisesToContext = WeakConcurrentProviderImpl.createWeakSpanMap();

    @Override
    @Nonnull
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("scala-future", "experimental");
    }

    public static class RunInstrumentation
    extends FutureInstrumentation {
        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.named("scala.concurrent.impl.Promise$Transformation");
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("run").and(ElementMatchers.returns(Void.TYPE));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Object onEnter(@Advice.This Object thiz) {
                AbstractSpan<?> context = promisesToContext.get(thiz);
                if (context != null) {
                    context.activate();
                    promisesToContext.remove(thiz);
                }
                return context;
            }

            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static void onExit(@Advice.Enter @Nullable Object abstractSpanObj) {
                if (abstractSpanObj instanceof AbstractSpan) {
                    AbstractSpan context = (AbstractSpan)abstractSpanObj;
                    context.deactivate();
                }
            }
        }
    }

    public static class ConstructorInstrumentation
    extends FutureInstrumentation {
        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.named("scala.concurrent.impl.Promise$Transformation");
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.isConstructor();
        }

        public static class AdviceClass {
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static void onExit(@Advice.This Object thiz) {
                AbstractSpan<?> context = TracerAwareInstrumentation.tracer.getActive();
                if (context != null) {
                    promisesToContext.put(thiz, context);
                }
            }
        }
    }
}

