/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.resttemplate;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.httpclient.HttpClientHelper;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.resttemplate.SpringRestRequestHeaderSetter;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public class SpringRestTemplateAdvice {
    private static final Logger logger = LoggerFactory.getLogger(SpringRestTemplateAdvice.class);

    @Nullable
    @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
    public static Object beforeExecute(@Advice.This ClientHttpRequest request) {
        logger.trace("Enter advice for method {}#execute()", (Object)request.getClass().getName());
        AbstractSpan<?> parent = TracerAwareInstrumentation.tracer.getActive();
        if (parent == null) {
            return null;
        }
        URI uri = request.getURI();
        Span span = HttpClientHelper.startHttpClientSpan(parent, Objects.toString(request.getMethod()), uri, uri.getHost());
        if (span != null) {
            span.activate();
            span.propagateTraceContext(request, SpringRestRequestHeaderSetter.INSTANCE);
        } else {
            parent.propagateTraceContext(request, SpringRestRequestHeaderSetter.INSTANCE);
        }
        return span;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
    public static void afterExecute(@Advice.Return @Nullable ClientHttpResponse clientHttpResponse, @Advice.Enter @Nullable Object spanObj, @Advice.Thrown @Nullable Throwable t) throws IOException {
        logger.trace("Exit advice for RestTemplate client execute() method, span object: {}", spanObj);
        if (spanObj instanceof Span) {
            Span span = (Span)spanObj;
            try {
                if (clientHttpResponse != null) {
                    span.getContext().getHttp().withStatusCode(clientHttpResponse.getRawStatusCode());
                }
                if (t != null) {
                    span.withOutcome(Outcome.FAILURE);
                }
                span.captureException(t);
            }
            finally {
                ((Span)span.deactivate()).end();
            }
        }
    }
}

