/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.report.serialize;

import co.elastic.apm.agent.collections.LongList;
import co.elastic.apm.agent.impl.context.AbstractContext;
import co.elastic.apm.agent.impl.context.CloudOrigin;
import co.elastic.apm.agent.impl.context.Db;
import co.elastic.apm.agent.impl.context.Destination;
import co.elastic.apm.agent.impl.context.Headers;
import co.elastic.apm.agent.impl.context.Http;
import co.elastic.apm.agent.impl.context.Message;
import co.elastic.apm.agent.impl.context.Request;
import co.elastic.apm.agent.impl.context.Response;
import co.elastic.apm.agent.impl.context.ServiceOrigin;
import co.elastic.apm.agent.impl.context.ServiceTarget;
import co.elastic.apm.agent.impl.context.Socket;
import co.elastic.apm.agent.impl.context.SpanContext;
import co.elastic.apm.agent.impl.context.TransactionContext;
import co.elastic.apm.agent.impl.context.Url;
import co.elastic.apm.agent.impl.context.User;
import co.elastic.apm.agent.impl.error.ErrorCapture;
import co.elastic.apm.agent.impl.metadata.Agent;
import co.elastic.apm.agent.impl.metadata.CloudProviderInfo;
import co.elastic.apm.agent.impl.metadata.Framework;
import co.elastic.apm.agent.impl.metadata.Language;
import co.elastic.apm.agent.impl.metadata.MetaData;
import co.elastic.apm.agent.impl.metadata.NameAndIdField;
import co.elastic.apm.agent.impl.metadata.Node;
import co.elastic.apm.agent.impl.metadata.ProcessInfo;
import co.elastic.apm.agent.impl.metadata.RuntimeInfo;
import co.elastic.apm.agent.impl.metadata.Service;
import co.elastic.apm.agent.impl.metadata.SystemInfo;
import co.elastic.apm.agent.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Composite;
import co.elastic.apm.agent.impl.transaction.DroppedSpanStats;
import co.elastic.apm.agent.impl.transaction.Faas;
import co.elastic.apm.agent.impl.transaction.FaasTrigger;
import co.elastic.apm.agent.impl.transaction.Id;
import co.elastic.apm.agent.impl.transaction.OTelSpanKind;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.SpanCount;
import co.elastic.apm.agent.impl.transaction.StackFrame;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.metrics.Labels;
import co.elastic.apm.agent.report.ApmServerClient;
import co.elastic.apm.agent.report.serialize.PayloadSerializer;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.util.HexUtils;
import co.elastic.apm.agent.util.PotentiallyMultiValuedMap;
import com.dslplatform.json.BoolConverter;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.NumberConverter;
import com.dslplatform.json.StringConverter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class DslJsonSerializer
implements PayloadSerializer {
    public static final int BUFFER_SIZE = 16384;
    public static final int MAX_VALUE_LENGTH = 1024;
    public static final int MAX_LONG_STRING_VALUE_LENGTH = 10000;
    private static final byte NEW_LINE = 10;
    private static final Logger logger = LoggerFactory.getLogger(DslJsonSerializer.class);
    private static final String[] DISALLOWED_IN_PROPERTY_NAME = new String[]{".", "*", "\""};
    private static final List<String> excludedStackFrames = Arrays.asList("java.lang.reflect", "com.sun", "sun.", "jdk.internal.");
    final JsonWriter jw;
    private final StringBuilder replaceBuilder = new StringBuilder(10001);
    private final StacktraceConfiguration stacktraceConfiguration;
    private final ApmServerClient apmServerClient;
    @Nullable
    private OutputStream os;
    private final Future<MetaData> metaData;
    @Nullable
    private byte[] serializedMetaData;

    public DslJsonSerializer(StacktraceConfiguration stacktraceConfiguration, ApmServerClient apmServerClient, Future<MetaData> metaData) {
        this.stacktraceConfiguration = stacktraceConfiguration;
        this.apmServerClient = apmServerClient;
        this.metaData = metaData;
        this.jw = new DslJson(new DslJson.Settings()).newWriter(16384);
    }

    @Override
    public void setOutputStream(final OutputStream os) {
        this.os = logger.isTraceEnabled() ? new ByteArrayOutputStream(){

            @Override
            public void flush() throws IOException {
                os.write(this.buf, 0, this.size());
                os.flush();
                logger.trace(new String(this.buf, 0, this.size(), StandardCharsets.UTF_8));
            }
        } : os;
        this.jw.reset(this.os);
    }

    @Override
    public void fullFlush() throws IOException {
        this.jw.flush();
        try {
            if (this.os != null) {
                this.os.flush();
            }
        }
        finally {
            this.jw.reset();
        }
    }

    @Override
    public void flushToOutputStream() {
        this.jw.flush();
    }

    @Override
    public void appendMetaDataNdJsonToStream() throws PayloadSerializer.UninitializedException {
        this.assertMetaDataReady();
        this.jw.writeByte((byte)123);
        this.writeFieldName("metadata");
        this.appendMetadataToStream();
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)10);
    }

    static void serializeMetadata(MetaData metaData, JsonWriter metadataJW, boolean supportsConfiguredAndDetectedHostname) {
        StringBuilder metadataReplaceBuilder = new StringBuilder();
        metadataJW.writeByte((byte)123);
        DslJsonSerializer.serializeService(metaData.getService(), metadataReplaceBuilder, metadataJW);
        metadataJW.writeByte((byte)44);
        DslJsonSerializer.serializeProcess(metaData.getProcess(), metadataReplaceBuilder, metadataJW);
        metadataJW.writeByte((byte)44);
        DslJsonSerializer.serializeGlobalLabels(metaData.getGlobalLabelKeys(), metaData.getGlobalLabelValues(), metadataReplaceBuilder, metadataJW);
        DslJsonSerializer.serializeSystem(metaData.getSystem(), metadataReplaceBuilder, metadataJW, supportsConfiguredAndDetectedHostname);
        if (metaData.getCloudProviderInfo() != null) {
            metadataJW.writeByte((byte)44);
            DslJsonSerializer.serializeCloudProvider(metaData.getCloudProviderInfo(), metadataReplaceBuilder, metadataJW);
        }
        metadataJW.writeByte((byte)125);
    }

    @Override
    public void appendMetadataToStream() throws PayloadSerializer.UninitializedException {
        this.assertMetaDataReady();
        this.jw.writeAscii(this.serializedMetaData);
    }

    private void assertMetaDataReady() throws PayloadSerializer.UninitializedException {
        if (this.serializedMetaData == null) {
            throw new PayloadSerializer.UninitializedException("Cannot serialize metadata as it is not ready yet. Call blockUntilReady()");
        }
    }

    @Override
    public void blockUntilReady() throws Exception {
        if (this.serializedMetaData == null) {
            JsonWriter metadataJW = new DslJson(new DslJson.Settings()).newWriter(4096);
            DslJsonSerializer.serializeMetadata(this.metaData.get(5L, TimeUnit.SECONDS), metadataJW, this.apmServerClient.supportsConfiguredAndDetectedHostname());
            this.serializedMetaData = metadataJW.toByteArray();
        }
    }

    private static void serializeGlobalLabels(ArrayList<String> globalLabelKeys, ArrayList<String> globalLabelValues, StringBuilder replaceBuilder, JsonWriter jw) {
        if (!globalLabelKeys.isEmpty()) {
            DslJsonSerializer.writeFieldName("labels", jw);
            jw.writeByte((byte)123);
            DslJsonSerializer.writeStringValue(DslJsonSerializer.sanitizePropertyName(globalLabelKeys.get(0), replaceBuilder), replaceBuilder, jw);
            jw.writeByte((byte)58);
            DslJsonSerializer.writeStringValue(globalLabelValues.get(0), replaceBuilder, jw);
            for (int i = 1; i < globalLabelKeys.size(); ++i) {
                jw.writeByte((byte)44);
                DslJsonSerializer.writeStringValue(DslJsonSerializer.sanitizePropertyName(globalLabelKeys.get(i), replaceBuilder), replaceBuilder, jw);
                jw.writeByte((byte)58);
                DslJsonSerializer.writeStringValue(globalLabelValues.get(i), replaceBuilder, jw);
            }
            jw.writeByte((byte)125);
            jw.writeByte((byte)44);
        }
    }

    @Override
    public void serializeTransactionNdJson(Transaction transaction) {
        this.jw.writeByte((byte)123);
        this.writeFieldName("transaction");
        this.serializeTransaction(transaction);
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)10);
    }

    @Override
    public void serializeSpanNdJson(Span span) {
        this.jw.writeByte((byte)123);
        this.writeFieldName("span");
        this.serializeSpan(span);
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)10);
    }

    @Override
    public void serializeErrorNdJson(ErrorCapture error) {
        this.jw.writeByte((byte)123);
        this.writeFieldName("error");
        this.serializeError(error);
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)10);
    }

    @Override
    public int getBufferSize() {
        return this.jw.size();
    }

    @Override
    public void serializeFileMetaData(File file) {
        this.jw.writeByte((byte)123);
        this.writeFieldName("metadata");
        this.jw.writeByte((byte)123);
        this.writeFieldName("log");
        this.jw.writeByte((byte)123);
        this.writeFieldName("file");
        this.jw.writeByte((byte)123);
        this.writeField("path", file.getAbsolutePath());
        this.writeLastField("name", file.getName());
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)10);
    }

    @Override
    public JsonWriter getJsonWriter() {
        return this.jw;
    }

    @Override
    public void writeBytes(byte[] bytes, int len) {
        this.jw.writeAscii(bytes, len);
    }

    private void serializeError(ErrorCapture errorCapture) {
        this.jw.writeByte((byte)123);
        this.writeTimestamp(errorCapture.getTimestamp());
        this.serializeErrorTransactionInfo(errorCapture.getTransactionInfo());
        if (errorCapture.getTraceContext().hasContent()) {
            this.serializeTraceContext(errorCapture.getTraceContext(), true);
        }
        this.serializeContext(null, errorCapture.getContext(), errorCapture.getTraceContext());
        this.writeField("culprit", errorCapture.getCulprit());
        this.serializeException(errorCapture.getException());
        this.jw.writeByte((byte)125);
    }

    private void serializeErrorTransactionInfo(ErrorCapture.TransactionInfo errorTransactionInfo) {
        this.writeFieldName("transaction");
        this.jw.writeByte((byte)123);
        this.writeField("name", errorTransactionInfo.getName());
        if (errorTransactionInfo.getType() != null) {
            this.writeField("type", errorTransactionInfo.getType());
        }
        this.writeLastField("sampled", errorTransactionInfo.isSampled());
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    private void serializeException(@Nullable Throwable exception) {
        this.writeFieldName("exception");
        this.recursiveSerializeException(exception);
    }

    private void recursiveSerializeException(@Nullable Throwable exception) {
        this.jw.writeByte((byte)123);
        if (exception != null) {
            this.writeField("message", String.valueOf(exception.getMessage()));
            this.serializeStacktrace(exception.getStackTrace());
            this.writeFieldName("type");
            this.writeStringValue(exception.getClass().getName());
            Throwable cause = exception.getCause();
            if (cause != null) {
                this.jw.writeByte((byte)44);
                this.writeFieldName("cause");
                this.jw.writeByte((byte)91);
                this.recursiveSerializeException(cause);
                this.jw.writeByte((byte)93);
            }
        }
        this.jw.writeByte((byte)125);
    }

    public String toJsonString(Transaction transaction) {
        this.jw.reset();
        this.serializeTransaction(transaction);
        String s = this.jw.toString();
        this.jw.reset();
        return s;
    }

    public String toJsonString(Span span) {
        this.jw.reset();
        this.serializeSpan(span);
        String s = this.jw.toString();
        this.jw.reset();
        return s;
    }

    public String toJsonString(ErrorCapture error) {
        this.jw.reset();
        this.serializeError(error);
        String s = this.jw.toString();
        this.jw.reset();
        return s;
    }

    public String toJsonString(StackTraceElement stackTraceElement) {
        this.jw.reset();
        this.serializeStackTraceElement(stackTraceElement);
        String s = this.jw.toString();
        this.jw.reset();
        return s;
    }

    public String toString() {
        return this.jw.toString();
    }

    private static void serializeService(Service service, StringBuilder replaceBuilder, JsonWriter jw) {
        RuntimeInfo runtime;
        Node node;
        Framework framework;
        Language language;
        DslJsonSerializer.writeFieldName("service", jw);
        jw.writeByte((byte)123);
        DslJsonSerializer.writeField("name", service.getName(), replaceBuilder, jw);
        DslJsonSerializer.writeField("id", service.getId(), replaceBuilder, jw);
        DslJsonSerializer.writeField("environment", service.getEnvironment(), replaceBuilder, jw);
        Agent agent = service.getAgent();
        if (agent != null) {
            DslJsonSerializer.serializeAgent(agent, replaceBuilder, jw);
        }
        if ((language = service.getLanguage()) != null) {
            DslJsonSerializer.serializeLanguage(language, replaceBuilder, jw);
        }
        if ((framework = service.getFramework()) != null) {
            DslJsonSerializer.serializeFramework(framework, replaceBuilder, jw);
        }
        if ((node = service.getNode()) != null && node.hasContents()) {
            DslJsonSerializer.serializeNode(node, replaceBuilder, jw);
        }
        if ((runtime = service.getRuntime()) != null) {
            DslJsonSerializer.serializeRuntime(runtime, replaceBuilder, jw);
        }
        DslJsonSerializer.writeLastField("version", service.getVersion(), replaceBuilder, jw);
        jw.writeByte((byte)125);
    }

    private static void serializeService(@Nullable CharSequence serviceName, @Nullable CharSequence serviceVersion, @Nullable ServiceTarget serviceTarget, StringBuilder replaceBuilder, JsonWriter jw) {
        boolean hasServiceTarget;
        boolean bl = hasServiceTarget = serviceTarget != null && serviceTarget.hasContent();
        if (serviceName == null && !hasServiceTarget) {
            return;
        }
        DslJsonSerializer.writeFieldName("service", jw);
        jw.writeByte((byte)123);
        if (serviceName != null) {
            DslJsonSerializer.writeFieldName("name", jw);
            DslJsonSerializer.writeStringValue(serviceName, replaceBuilder, jw);
            if (serviceVersion != null) {
                jw.writeByte((byte)44);
                DslJsonSerializer.writeFieldName("version", jw);
                DslJsonSerializer.writeStringValue(serviceVersion, replaceBuilder, jw);
            }
        }
        if (hasServiceTarget) {
            if (serviceName != null) {
                jw.writeByte((byte)44);
            }
            DslJsonSerializer.writeFieldName("target", jw);
            jw.writeByte((byte)123);
            String targetType = serviceTarget.getType();
            CharSequence targetName = serviceTarget.getName();
            if (targetType != null) {
                DslJsonSerializer.writeFieldName("type", jw);
                DslJsonSerializer.writeStringValue(targetType, replaceBuilder, jw);
            }
            if (targetName != null) {
                if (targetType != null) {
                    jw.writeByte((byte)44);
                }
                DslJsonSerializer.writeFieldName("name", jw);
                DslJsonSerializer.writeStringValue(targetName, replaceBuilder, jw);
            }
            jw.writeByte((byte)125);
        }
        jw.writeByte((byte)125);
        jw.writeByte((byte)44);
    }

    private static void serializeService(@Nullable String name, @Nullable String version, StringBuilder replaceBuilder, JsonWriter jw) {
        DslJsonSerializer.serializeService(name, version, null, replaceBuilder, jw);
    }

    private static void serializeAgent(Agent agent, StringBuilder replaceBuilder, JsonWriter jw) {
        DslJsonSerializer.writeFieldName("agent", jw);
        jw.writeByte((byte)123);
        DslJsonSerializer.writeField("name", agent.getName(), replaceBuilder, jw);
        DslJsonSerializer.writeField("ephemeral_id", agent.getEphemeralId(), replaceBuilder, jw);
        DslJsonSerializer.writeLastField("version", agent.getVersion(), replaceBuilder, jw);
        jw.writeByte((byte)125);
        jw.writeByte((byte)44);
    }

    private void serializeFramework(String frameworkName, @Nullable String frameworkVersion) {
        this.writeFieldName("framework");
        this.jw.writeByte((byte)123);
        this.writeField("version", frameworkVersion);
        this.writeLastField("name", frameworkName);
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    private static void serializeLanguage(Language language, StringBuilder replaceBuilder, JsonWriter jw) {
        DslJsonSerializer.writeFieldName("language", jw);
        jw.writeByte((byte)123);
        DslJsonSerializer.writeField("name", language.getName(), replaceBuilder, jw);
        DslJsonSerializer.writeLastField("version", language.getVersion(), replaceBuilder, jw);
        jw.writeByte((byte)125);
        jw.writeByte((byte)44);
    }

    private static void serializeFramework(Framework framework, StringBuilder replaceBuilder, JsonWriter jw) {
        DslJsonSerializer.writeFieldName("framework", jw);
        jw.writeByte((byte)123);
        DslJsonSerializer.writeField("name", framework.getName(), replaceBuilder, jw);
        DslJsonSerializer.writeLastField("version", framework.getVersion(), replaceBuilder, jw);
        jw.writeByte((byte)125);
        jw.writeByte((byte)44);
    }

    private static void serializeNode(Node node, StringBuilder replaceBuilder, JsonWriter jw) {
        DslJsonSerializer.writeFieldName("node", jw);
        jw.writeByte((byte)123);
        DslJsonSerializer.writeLastField("configured_name", node.getName(), replaceBuilder, jw);
        jw.writeByte((byte)125);
        jw.writeByte((byte)44);
    }

    private static void serializeRuntime(RuntimeInfo runtime, StringBuilder replaceBuilder, JsonWriter jw) {
        DslJsonSerializer.writeFieldName("runtime", jw);
        jw.writeByte((byte)123);
        DslJsonSerializer.writeField("name", runtime.getName(), replaceBuilder, jw);
        DslJsonSerializer.writeLastField("version", runtime.getVersion(), replaceBuilder, jw);
        jw.writeByte((byte)125);
        jw.writeByte((byte)44);
    }

    private static void serializeProcess(ProcessInfo process, StringBuilder replaceBuilder, JsonWriter jw) {
        DslJsonSerializer.writeFieldName("process", jw);
        jw.writeByte((byte)123);
        DslJsonSerializer.writeField("pid", process.getPid(), jw);
        if (process.getPpid() != null) {
            DslJsonSerializer.writeField("ppid", process.getPpid(), jw);
        }
        List<String> argv = process.getArgv();
        DslJsonSerializer.writeField("argv", argv, jw);
        DslJsonSerializer.writeLastField("title", process.getTitle(), replaceBuilder, jw);
        jw.writeByte((byte)125);
    }

    private static void serializeSystem(SystemInfo system, StringBuilder replaceBuilder, JsonWriter jw, boolean supportsConfiguredAndDetectedHostname) {
        DslJsonSerializer.writeFieldName("system", jw);
        jw.writeByte((byte)123);
        DslJsonSerializer.serializeContainerInfo(system.getContainerInfo(), replaceBuilder, jw);
        DslJsonSerializer.serializeKubernetesInfo(system.getKubernetesInfo(), replaceBuilder, jw);
        DslJsonSerializer.writeField("architecture", system.getArchitecture(), replaceBuilder, jw);
        if (supportsConfiguredAndDetectedHostname) {
            String configuredHostname = system.getConfiguredHostname();
            if (configuredHostname != null && !configuredHostname.isEmpty()) {
                DslJsonSerializer.writeField("configured_hostname", configuredHostname, replaceBuilder, jw);
            } else {
                String detectedHostname = system.getDetectedHostname();
                if (detectedHostname != null && !detectedHostname.isEmpty()) {
                    DslJsonSerializer.writeField("detected_hostname", detectedHostname, replaceBuilder, jw);
                }
            }
        } else {
            DslJsonSerializer.writeField("hostname", system.getHostname(), replaceBuilder, jw);
        }
        DslJsonSerializer.writeLastField("platform", system.getPlatform(), replaceBuilder, jw);
        jw.writeByte((byte)125);
    }

    private static void serializeCloudProvider(CloudProviderInfo cloudProviderInfo, StringBuilder replaceBuilder, JsonWriter jw) {
        DslJsonSerializer.writeFieldName("cloud", jw);
        jw.writeByte((byte)123);
        DslJsonSerializer.serializeNameAndIdField(cloudProviderInfo.getAccount(), "account", replaceBuilder, jw);
        DslJsonSerializer.serializeNameAndIdField(cloudProviderInfo.getInstance(), "instance", replaceBuilder, jw);
        DslJsonSerializer.serializeNameAndIdField(cloudProviderInfo.getProject(), "project", replaceBuilder, jw);
        if (cloudProviderInfo.getMachine() != null) {
            DslJsonSerializer.writeFieldName("machine", jw);
            jw.writeByte((byte)123);
            DslJsonSerializer.writeLastField("type", cloudProviderInfo.getMachine().getType(), replaceBuilder, jw);
            jw.writeByte((byte)125);
            jw.writeByte((byte)44);
        }
        DslJsonSerializer.writeField("availability_zone", cloudProviderInfo.getAvailabilityZone(), replaceBuilder, jw);
        DslJsonSerializer.writeField("region", cloudProviderInfo.getRegion(), replaceBuilder, jw);
        if (null != cloudProviderInfo.getService()) {
            DslJsonSerializer.writeFieldName("service", jw);
            jw.writeByte((byte)123);
            DslJsonSerializer.writeLastField("name", cloudProviderInfo.getService().getName(), replaceBuilder, jw);
            jw.writeByte((byte)125);
            jw.writeByte((byte)44);
        }
        DslJsonSerializer.writeLastField("provider", cloudProviderInfo.getProvider(), replaceBuilder, jw);
        jw.writeByte((byte)125);
    }

    private static void serializeNameAndIdField(@Nullable NameAndIdField nameAndIdField, String fieldName, StringBuilder replaceBuilder, JsonWriter jw) {
        if (nameAndIdField != null && !nameAndIdField.isEmpty()) {
            String name;
            DslJsonSerializer.writeFieldName(fieldName, jw);
            jw.writeByte((byte)123);
            boolean idWritten = false;
            String id = nameAndIdField.getId();
            if (id != null) {
                DslJsonSerializer.writeFieldName("id", jw);
                DslJsonSerializer.writeStringValue(id, replaceBuilder, jw);
                idWritten = true;
            }
            if ((name = nameAndIdField.getName()) != null) {
                if (idWritten) {
                    jw.writeByte((byte)44);
                }
                DslJsonSerializer.writeFieldName("name", jw);
                DslJsonSerializer.writeStringValue(name, replaceBuilder, jw);
            }
            jw.writeByte((byte)125);
            jw.writeByte((byte)44);
        }
    }

    private static void serializeContainerInfo(@Nullable SystemInfo.Container container, StringBuilder replaceBuilder, JsonWriter jw) {
        if (container != null) {
            DslJsonSerializer.writeFieldName("container", jw);
            jw.writeByte((byte)123);
            DslJsonSerializer.writeLastField("id", container.getId(), replaceBuilder, jw);
            jw.writeByte((byte)125);
            jw.writeByte((byte)44);
        }
    }

    private static void serializeKubernetesInfo(@Nullable SystemInfo.Kubernetes kubernetes, StringBuilder replaceBuilder, JsonWriter jw) {
        if (kubernetes != null && kubernetes.hasContent()) {
            DslJsonSerializer.writeFieldName("kubernetes", jw);
            jw.writeByte((byte)123);
            DslJsonSerializer.serializeKubeNodeInfo(kubernetes.getNode(), replaceBuilder, jw);
            DslJsonSerializer.serializeKubePodInfo(kubernetes.getPod(), replaceBuilder, jw);
            DslJsonSerializer.writeLastField("namespace", kubernetes.getNamespace(), replaceBuilder, jw);
            jw.writeByte((byte)125);
            jw.writeByte((byte)44);
        }
    }

    private static void serializeKubePodInfo(@Nullable SystemInfo.Kubernetes.Pod pod, StringBuilder replaceBuilder, JsonWriter jw) {
        if (pod != null) {
            DslJsonSerializer.writeFieldName("pod", jw);
            jw.writeByte((byte)123);
            String podName = pod.getName();
            if (podName != null) {
                DslJsonSerializer.writeField("name", podName, replaceBuilder, jw);
            }
            DslJsonSerializer.writeLastField("uid", pod.getUid(), replaceBuilder, jw);
            jw.writeByte((byte)125);
            jw.writeByte((byte)44);
        }
    }

    private static void serializeKubeNodeInfo(@Nullable SystemInfo.Kubernetes.Node node, StringBuilder replaceBuilder, JsonWriter jw) {
        if (node != null) {
            DslJsonSerializer.writeFieldName("node", jw);
            jw.writeByte((byte)123);
            DslJsonSerializer.writeLastField("name", node.getName(), replaceBuilder, jw);
            jw.writeByte((byte)125);
            jw.writeByte((byte)44);
        }
    }

    private void serializeTransaction(Transaction transaction) {
        TraceContext traceContext = transaction.getTraceContext();
        this.jw.writeByte((byte)123);
        this.writeTimestamp(transaction.getTimestamp());
        this.writeField("name", transaction.getNameForSerialization());
        this.serializeTraceContext(traceContext, false);
        this.serializeSpanLinks(transaction.getSpanLinks());
        this.writeField("type", transaction.getType());
        this.writeField("duration", transaction.getDurationMs());
        this.writeField("result", transaction.getResult());
        this.writeField("outcome", transaction.getOutcome().toString());
        this.serializeFaas(transaction.getFaas());
        this.serializeContext(transaction, transaction.getContext(), traceContext);
        this.serializeSpanCount(transaction.getSpanCount());
        if (transaction.isSampled()) {
            this.serializeDroppedSpanStats(transaction.getDroppedSpanStats());
        }
        this.serializeOTel(transaction);
        double sampleRate = traceContext.getSampleRate();
        if (!Double.isNaN(sampleRate)) {
            this.writeField("sample_rate", sampleRate);
        }
        this.writeLastField("sampled", transaction.isSampled());
        this.jw.writeByte((byte)125);
    }

    private void serializeTraceContext(TraceContext traceContext, boolean serializeTransactionId) {
        this.writeNonLastIdField("id", traceContext.getId());
        if (!traceContext.getTraceId().isEmpty()) {
            this.writeNonLastIdField("trace_id", traceContext.getTraceId());
            if (serializeTransactionId && !traceContext.getTransactionId().isEmpty()) {
                this.writeNonLastIdField("transaction_id", traceContext.getTransactionId());
            }
            if (!traceContext.getParentId().isEmpty()) {
                this.writeNonLastIdField("parent_id", traceContext.getParentId());
            }
        }
    }

    private void serializeSpan(Span span) {
        TraceContext traceContext = span.getTraceContext();
        this.jw.writeByte((byte)123);
        this.writeField("name", span.getNameForSerialization());
        this.writeTimestamp(span.getTimestamp());
        if (!span.isSync()) {
            this.writeField("sync", span.isSync());
        }
        this.writeField("outcome", span.getOutcome().toString());
        this.serializeTraceContext(traceContext, true);
        this.serializeSpanLinks(span.getSpanLinks());
        this.writeField("duration", span.getDurationMs());
        if (span.getStacktrace() != null) {
            this.serializeStacktrace(span.getStacktrace().getStackTrace());
        } else if (span.getStackFrames() != null) {
            this.serializeStackTrace(span.getStackFrames());
        }
        this.serializeSpanContext(span.getContext(), traceContext);
        this.writeHexArray("child_ids", span.getChildIds());
        double sampleRate = traceContext.getSampleRate();
        if (!Double.isNaN(sampleRate)) {
            this.writeField("sample_rate", sampleRate);
        }
        this.serializeOTel(span);
        if (span.isComposite()) {
            this.serializeComposite(span.getComposite());
        }
        this.serializeSpanType(span);
        this.jw.writeByte((byte)125);
    }

    private void serializeSpanLinks(List<TraceContext> spanLinks) {
        if (!spanLinks.isEmpty()) {
            this.writeFieldName("links");
            this.jw.writeByte((byte)91);
            int size = spanLinks.size();
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    this.jw.writeByte((byte)44);
                }
                TraceContext traceContext = spanLinks.get(i);
                this.jw.writeByte((byte)123);
                this.writeNonLastIdField("trace_id", traceContext.getTraceId());
                this.writeIdField("span_id", traceContext.getParentId());
                this.jw.writeByte((byte)125);
            }
            this.jw.writeByte((byte)93);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializeOTel(AbstractSpan<?> span) {
        boolean hasKind;
        OTelSpanKind kind = span.getOtelKind();
        Map<String, Object> attributes = span.getOtelAttributes();
        boolean hasAttributes = !attributes.isEmpty();
        boolean bl = hasKind = kind != null;
        if (hasKind || hasAttributes) {
            this.writeFieldName("otel");
            this.jw.writeByte((byte)123);
            if (hasKind) {
                this.writeFieldName("span_kind");
                this.writeStringValue(kind.name());
            }
            if (hasAttributes) {
                if (hasKind) {
                    this.jw.writeByte((byte)44);
                }
                this.writeFieldName("attributes");
                this.jw.writeByte((byte)123);
                int index = 0;
                for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                    if (index++ > 0) {
                        this.jw.writeByte((byte)44);
                    }
                    this.writeFieldName(entry.getKey());
                    Object o = entry.getValue();
                    if (o instanceof Number) {
                        this.serializeNumber((Number)o, this.jw);
                        continue;
                    }
                    if (o instanceof String) {
                        this.writeStringValue((String)o);
                        continue;
                    }
                    if (!(o instanceof Boolean)) continue;
                    BoolConverter.serialize((Boolean)o, this.jw);
                }
                this.jw.writeByte((byte)125);
            }
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializeNumber(Number n, JsonWriter jw) {
        if (n instanceof Integer) {
            NumberConverter.serialize(n.intValue(), jw);
        } else if (n instanceof Long) {
            NumberConverter.serialize(n.longValue(), jw);
        } else if (n instanceof Double) {
            NumberConverter.serialize(n.doubleValue(), jw);
        } else if (n instanceof Float) {
            NumberConverter.serialize(n.floatValue(), jw);
        }
    }

    private void serializeComposite(Composite composite) {
        DslJsonSerializer.writeFieldName("composite", this.jw);
        this.jw.writeByte((byte)123);
        this.writeField("count", composite.getCount());
        this.writeField("sum", composite.getSumMs());
        this.writeLastField("compression_strategy", composite.getCompressionStrategy());
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    private void serializeServiceNameWithFramework(@Nullable Transaction transaction, TraceContext traceContext, ServiceOrigin serviceOrigin) {
        boolean isFrameworkNameNotNull;
        String serviceName = traceContext.getServiceName();
        String serviceVersion = traceContext.getServiceVersion();
        boolean bl = isFrameworkNameNotNull = transaction != null && transaction.getFrameworkName() != null;
        if (serviceName != null || serviceVersion != null || isFrameworkNameNotNull || serviceOrigin.hasContent()) {
            this.writeFieldName("service");
            this.jw.writeByte((byte)123);
            if (serviceOrigin.hasContent()) {
                this.serializeServiceOrigin(serviceOrigin);
            }
            if (isFrameworkNameNotNull) {
                this.serializeFramework(transaction.getFrameworkName(), transaction.getFrameworkVersion());
            }
            this.writeField("name", serviceName);
            this.writeLastField("version", serviceVersion);
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializeServiceOrigin(ServiceOrigin serviceOrigin) {
        this.writeFieldName("origin");
        this.jw.writeByte((byte)123);
        if (null != serviceOrigin.getId()) {
            this.writeField("id", serviceOrigin.getId());
        }
        if (null != serviceOrigin.getVersion()) {
            this.writeField("version", serviceOrigin.getVersion());
        }
        this.writeLastField("name", serviceOrigin.getName());
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    private void serializeCloudOrigin(CloudOrigin cloudOrigin) {
        this.writeFieldName("cloud");
        this.jw.writeByte((byte)123);
        this.writeFieldName("origin");
        this.jw.writeByte((byte)123);
        if (null != cloudOrigin.getAccountId()) {
            this.writeFieldName("account");
            this.jw.writeByte((byte)123);
            this.writeLastField("id", cloudOrigin.getAccountId());
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)44);
        }
        if (null != cloudOrigin.getServiceName()) {
            this.writeFieldName("service");
            this.jw.writeByte((byte)123);
            this.writeLastField("name", cloudOrigin.getServiceName());
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)44);
        }
        if (null != cloudOrigin.getRegion()) {
            this.writeField("region", cloudOrigin.getRegion());
        }
        this.writeLastField("provider", cloudOrigin.getProvider());
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    private void serializeSpanType(Span span) {
        this.writeFieldName("type");
        String type = span.getType();
        if (type != null) {
            this.replaceBuilder.setLength(0);
            this.replaceBuilder.append(type);
            DslJsonSerializer.replace(this.replaceBuilder, ".", "_", 0);
            String subtype = span.getSubtype();
            String action = span.getAction();
            if (subtype != null || action != null) {
                this.replaceBuilder.append('.');
                int replaceStartIndex = this.replaceBuilder.length() + 1;
                if (subtype != null) {
                    this.replaceBuilder.append(subtype);
                    DslJsonSerializer.replace(this.replaceBuilder, ".", "_", replaceStartIndex);
                }
                if (action != null) {
                    this.replaceBuilder.append('.');
                    replaceStartIndex = this.replaceBuilder.length() + 1;
                    this.replaceBuilder.append(action);
                    DslJsonSerializer.replace(this.replaceBuilder, ".", "_", replaceStartIndex);
                }
            }
            this.writeStringValue(this.replaceBuilder);
        } else {
            this.jw.writeNull();
        }
    }

    private void serializeStacktrace(StackTraceElement[] stacktrace) {
        if (stacktrace.length > 0) {
            this.writeFieldName("stacktrace");
            this.jw.writeByte((byte)91);
            this.serializeStackTraceArrayElements(stacktrace);
            this.jw.writeByte((byte)93);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializeStackTraceArrayElements(StackTraceElement[] stacktrace) {
        boolean topMostElasticApmPackagesSkipped = false;
        int collectedStackFrames = 0;
        int stackTraceLimit = this.stacktraceConfiguration.getStackTraceLimit();
        if (stackTraceLimit < 0) {
            stackTraceLimit = stacktrace.length;
        }
        for (int i = 0; i < stacktrace.length && collectedStackFrames < stackTraceLimit; ++i) {
            StackTraceElement stackTraceElement = stacktrace[i];
            if (!topMostElasticApmPackagesSkipped && stackTraceElement.getClassName().startsWith("co.elastic.apm")) continue;
            topMostElasticApmPackagesSkipped = true;
            if (DslJsonSerializer.isExcluded(stackTraceElement)) continue;
            if (collectedStackFrames > 0) {
                this.jw.writeByte((byte)44);
            }
            this.serializeStackTraceElement(stackTraceElement);
            ++collectedStackFrames;
        }
    }

    private static boolean isExcluded(StackTraceElement stackTraceElement) {
        if (stackTraceElement.getFileName() == null) {
            return true;
        }
        String className = stackTraceElement.getClassName();
        int size = excludedStackFrames.size();
        for (int i = 0; i < size; ++i) {
            if (!className.startsWith(excludedStackFrames.get(i))) continue;
            return true;
        }
        return false;
    }

    private void serializeStackTraceElement(StackTraceElement stacktrace) {
        this.jw.writeByte((byte)123);
        this.writeField("filename", stacktrace.getFileName());
        this.writeField("classname", stacktrace.getClassName());
        this.writeField("function", stacktrace.getMethodName());
        this.writeField("library_frame", this.isLibraryFrame(stacktrace.getClassName()));
        this.writeField("lineno", stacktrace.getLineNumber());
        this.serializeStackFrameModule(stacktrace.getClassName());
        this.jw.writeByte((byte)125);
    }

    private void serializeStackFrameModule(String fullyQualifiedClassName) {
        this.writeFieldName("module");
        this.replaceBuilder.setLength(0);
        int lastDotIndex = fullyQualifiedClassName.lastIndexOf(46);
        if (lastDotIndex > 0) {
            this.replaceBuilder.append(fullyQualifiedClassName, 0, lastDotIndex);
        }
        DslJsonSerializer.writeStringBuilderValue(this.replaceBuilder, this.jw);
    }

    private boolean isLibraryFrame(String className) {
        for (String applicationPackage : this.stacktraceConfiguration.getApplicationPackages()) {
            if (!className.startsWith(applicationPackage)) continue;
            return false;
        }
        return true;
    }

    private void serializeStackTrace(List<StackFrame> stackTrace) {
        if (stackTrace.isEmpty()) {
            return;
        }
        this.writeFieldName("stacktrace");
        this.jw.writeByte((byte)91);
        StringBuilder replaceBuilder = this.replaceBuilder;
        int size = stackTrace.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.jw.writeByte((byte)44);
            }
            this.serializeStackTraceElement(stackTrace.get(i), replaceBuilder);
        }
        this.jw.writeByte((byte)93);
        this.jw.writeByte((byte)44);
    }

    private void serializeStackTraceElement(StackFrame frame, StringBuilder replaceBuilder) {
        this.jw.writeByte((byte)123);
        replaceBuilder.setLength(0);
        frame.appendFileName(replaceBuilder);
        this.writeField("filename", replaceBuilder);
        this.writeField("function", frame.getMethodName());
        this.writeField("library_frame", this.isLibraryFrame(frame.getClassName()));
        this.writeLastField("lineno", -1);
        this.jw.writeByte((byte)125);
    }

    private void serializeSpanContext(SpanContext context, TraceContext traceContext) {
        this.writeFieldName("context");
        this.jw.writeByte((byte)123);
        DslJsonSerializer.serializeService(traceContext.getServiceName(), traceContext.getServiceVersion(), context.getServiceTarget(), this.replaceBuilder, this.jw);
        this.serializeMessageContext(context.getMessage());
        this.serializeDbContext(context.getDb());
        this.serializeHttpContext(context.getHttp());
        this.serializeDestination(context.getDestination(), context.getServiceTarget().getDestinationResource());
        this.writeFieldName("tags");
        this.serializeLabels(context);
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    private void serializeDestination(Destination destination, @Nullable CharSequence resource) {
        if (destination.hasContent() || resource != null) {
            boolean hasServiceContent;
            this.writeFieldName("destination");
            this.jw.writeByte((byte)123);
            boolean hasAddress = destination.getAddress().length() > 0;
            boolean hasPort = destination.getPort() > 0;
            boolean bl = hasServiceContent = resource != null;
            if (hasAddress) {
                if (hasPort || hasServiceContent) {
                    this.writeField("address", destination.getAddress());
                } else {
                    this.writeLastField("address", destination.getAddress());
                }
            }
            if (hasPort) {
                if (hasServiceContent) {
                    this.writeField("port", destination.getPort());
                } else {
                    this.writeLastField("port", destination.getPort());
                }
            }
            this.serializeService(resource);
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializeService(@Nullable CharSequence resource) {
        if (resource != null) {
            this.writeFieldName("service");
            this.jw.writeByte((byte)123);
            this.writeEmptyField("name");
            this.writeEmptyField("type");
            this.writeLastField("resource", resource);
            this.jw.writeByte((byte)125);
        }
    }

    private void serializeMessageContext(Message message) {
        if (message.hasContent()) {
            this.writeFieldName("message");
            this.jw.writeByte((byte)123);
            StringBuilder body = message.getBodyForRead();
            if (body != null && body.length() > 0) {
                this.writeLongStringField("body", message.getBodyForWrite());
            }
            this.serializeMessageHeaders(message.getHeaders());
            int messageAge = (int)message.getAge();
            if (messageAge >= 0) {
                this.writeFieldName("age");
                this.jw.writeByte((byte)123);
                this.writeLastField("ms", messageAge);
                this.jw.writeByte((byte)125);
                this.jw.writeByte((byte)44);
            }
            if (message.getRoutingKey() != null && !message.getRoutingKey().isEmpty()) {
                this.writeField("routing_key", message.getRoutingKey());
            }
            this.writeFieldName("queue");
            this.jw.writeByte((byte)123);
            this.writeLastField("name", message.getQueueName());
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializeMessageHeaders(Headers headers) {
        if (!headers.isEmpty()) {
            this.writeFieldName("headers");
            this.jw.writeByte((byte)123);
            Iterator<Headers.Header> iterator = headers.iterator();
            while (iterator.hasNext()) {
                Headers.Header header = iterator.next();
                if (iterator.hasNext()) {
                    DslJsonSerializer.writeField(header.getKey(), header.getValue(), this.replaceBuilder, this.jw, true);
                    continue;
                }
                DslJsonSerializer.writeLastField(header.getKey(), header.getValue(), this.replaceBuilder, this.jw);
            }
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializeFaas(Faas faas) {
        if (faas.hasContent()) {
            this.writeFieldName("faas");
            this.jw.writeByte((byte)123);
            this.writeField("execution", faas.getExecution());
            this.writeField("id", faas.getId());
            this.writeField("name", faas.getName());
            this.writeField("version", faas.getVersion());
            this.serializeFaasTrigger(faas.getTrigger());
            this.writeLastField("coldstart", faas.isColdStart());
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializeFaasTrigger(FaasTrigger trigger) {
        if (trigger.hasContent()) {
            this.writeFieldName("trigger");
            this.jw.writeByte((byte)123);
            this.writeField("request_id", trigger.getRequestId());
            this.writeLastField("type", trigger.getType());
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializeDbContext(Db db) {
        if (db.hasContent()) {
            this.writeFieldName("db");
            this.jw.writeByte((byte)123);
            this.writeField("instance", db.getInstance());
            String statement = db.getStatement();
            if (statement != null) {
                this.writeLongStringField("statement", statement);
            } else {
                CharBuffer statementBuffer = db.getStatementBuffer();
                if (statementBuffer != null && statementBuffer.length() > 0) {
                    this.writeFieldName("statement");
                    this.jw.writeString(statementBuffer);
                    this.jw.writeByte((byte)44);
                }
            }
            long affectedRows = db.getAffectedRowsCount();
            if (affectedRows >= 0L) {
                this.writeField("rows_affected", affectedRows);
            }
            this.writeField("type", db.getType());
            this.writeField("link", db.getDbLink());
            this.writeLastField("user", db.getUser());
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializeHttpContext(Http http) {
        if (http.hasContent()) {
            this.writeFieldName("http");
            this.jw.writeByte((byte)123);
            this.writeField("method", http.getMethod());
            int statusCode = http.getStatusCode();
            if (statusCode > 0) {
                this.writeField("status_code", http.getStatusCode());
            }
            this.writeLastField("url", http.getUrl());
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializeSpanCount(SpanCount spanCount) {
        this.writeFieldName("span_count");
        this.jw.writeByte((byte)123);
        this.writeField("dropped", spanCount.getDropped().get());
        this.writeLastField("started", spanCount.getReported().get());
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    private void serializeDroppedSpanStats(DroppedSpanStats droppedSpanStats) {
        this.writeFieldName("dropped_spans_stats");
        this.jw.writeByte((byte)91);
        int i = 0;
        for (Map.Entry<DroppedSpanStats.StatsKey, DroppedSpanStats.Stats> stats : droppedSpanStats) {
            if (i++ >= 128) break;
            if (i > 1) {
                this.jw.writeByte((byte)44);
            }
            this.jw.writeByte((byte)123);
            this.writeField("destination_service_resource", stats.getKey().getDestinationServiceResource());
            this.writeField("service_target_type", stats.getKey().getServiceType());
            this.writeField("service_target_name", stats.getKey().getServiceName());
            this.writeField("outcome", stats.getKey().getOutcome().toString());
            this.writeFieldName("duration");
            this.jw.writeByte((byte)123);
            this.writeField("count", stats.getValue().getCount());
            this.writeFieldName("sum");
            this.jw.writeByte((byte)123);
            this.writeLastField("us", stats.getValue().getSum());
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)125);
        }
        this.jw.writeByte((byte)93);
        this.jw.writeByte((byte)44);
    }

    private void serializeContext(@Nullable Transaction transaction, TransactionContext context, TraceContext traceContext) {
        this.writeFieldName("context");
        this.jw.writeByte((byte)123);
        this.serializeServiceNameWithFramework(transaction, traceContext, context.getServiceOrigin());
        if (context.getUser().hasContent()) {
            this.serializeUser(context.getUser());
            this.jw.writeByte((byte)44);
        }
        this.serializeRequest(context.getRequest());
        this.serializeResponse(context.getResponse());
        this.serializeMessageContext(context.getMessage());
        if (context.hasCustom()) {
            this.writeFieldName("custom");
            DslJsonSerializer.serializeStringKeyScalarValueMap(context.getCustomIterator(), this.replaceBuilder, this.jw, true, true);
            this.jw.writeByte((byte)44);
        }
        if (context.getCloudOrigin().hasContent()) {
            this.serializeCloudOrigin(context.getCloudOrigin());
        }
        this.writeFieldName("tags");
        this.serializeLabels(context);
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    void serializeLabels(AbstractContext context) {
        if (context.hasLabels()) {
            DslJsonSerializer.serializeStringKeyScalarValueMap(context.getLabelIterator(), this.replaceBuilder, this.jw, false, this.apmServerClient.supportsNonStringLabels());
        } else {
            this.jw.writeByte((byte)123);
            this.jw.writeByte((byte)125);
        }
    }

    private static void serializeStringKeyScalarValueMap(Iterator<? extends Map.Entry<String, ?>> it, StringBuilder replaceBuilder, JsonWriter jw, boolean extendedStringLimit, boolean supportsNonStringValues) {
        jw.writeByte((byte)123);
        if (it.hasNext()) {
            Map.Entry<String, ?> kv = it.next();
            DslJsonSerializer.writeStringValue(DslJsonSerializer.sanitizePropertyName(kv.getKey(), replaceBuilder), replaceBuilder, jw);
            jw.writeByte((byte)58);
            DslJsonSerializer.serializeScalarValue(replaceBuilder, jw, kv.getValue(), extendedStringLimit, supportsNonStringValues);
            while (it.hasNext()) {
                jw.writeByte((byte)44);
                kv = it.next();
                DslJsonSerializer.writeStringValue(DslJsonSerializer.sanitizePropertyName(kv.getKey(), replaceBuilder), replaceBuilder, jw);
                jw.writeByte((byte)58);
                DslJsonSerializer.serializeScalarValue(replaceBuilder, jw, kv.getValue(), extendedStringLimit, supportsNonStringValues);
            }
        }
        jw.writeByte((byte)125);
    }

    static void serializeLabels(Labels labels, String serviceName, String serviceVersion, StringBuilder replaceBuilder, JsonWriter jw) {
        if (labels.getServiceName() != null) {
            DslJsonSerializer.serializeService(labels.getServiceName(), labels.getServiceVersion(), replaceBuilder, jw);
        } else {
            DslJsonSerializer.serializeService(serviceName, serviceVersion, replaceBuilder, jw);
        }
        if (!labels.isEmpty()) {
            if (labels.getTransactionName() != null || labels.getTransactionType() != null) {
                DslJsonSerializer.writeFieldName("transaction", jw);
                jw.writeByte((byte)123);
                DslJsonSerializer.writeField("name", labels.getTransactionName(), replaceBuilder, jw);
                DslJsonSerializer.writeLastField("type", labels.getTransactionType(), replaceBuilder, jw);
                jw.writeByte((byte)125);
                jw.writeByte((byte)44);
            }
            if (labels.getSpanType() != null || labels.getSpanSubType() != null) {
                DslJsonSerializer.writeFieldName("span", jw);
                jw.writeByte((byte)123);
                DslJsonSerializer.writeField("type", labels.getSpanType(), replaceBuilder, jw);
                DslJsonSerializer.writeLastField("subtype", labels.getSpanSubType(), replaceBuilder, jw);
                jw.writeByte((byte)125);
                jw.writeByte((byte)44);
            }
            DslJsonSerializer.writeFieldName("tags", jw);
            jw.writeByte((byte)123);
            DslJsonSerializer.serialize(labels, replaceBuilder, jw);
            jw.writeByte((byte)125);
            jw.writeByte((byte)44);
        }
    }

    private static void serialize(Labels labels, StringBuilder replaceBuilder, JsonWriter jw) {
        for (int i = 0; i < labels.size(); ++i) {
            if (i > 0) {
                jw.writeByte((byte)44);
            }
            DslJsonSerializer.writeStringValue(DslJsonSerializer.sanitizePropertyName(labels.getKey(i), replaceBuilder), replaceBuilder, jw);
            jw.writeByte((byte)58);
            DslJsonSerializer.serializeScalarValue(replaceBuilder, jw, labels.getValue(i), false, false);
        }
    }

    private static void serializeScalarValue(StringBuilder replaceBuilder, JsonWriter jw, Object value, boolean extendedStringLimit, boolean supportsNonStringValues) {
        if (value instanceof String) {
            if (extendedStringLimit) {
                DslJsonSerializer.writeLongStringValue((String)value, replaceBuilder, jw);
            } else {
                DslJsonSerializer.writeStringValue((String)value, replaceBuilder, jw);
            }
        } else if (value instanceof Number) {
            if (supportsNonStringValues) {
                NumberConverter.serialize(((Number)value).doubleValue(), jw);
            } else {
                jw.writeNull();
            }
        } else if (value instanceof Boolean) {
            if (supportsNonStringValues) {
                BoolConverter.serialize((Boolean)value, jw);
            } else {
                jw.writeNull();
            }
        } else {
            jw.writeString("invalid value");
        }
    }

    public static CharSequence sanitizePropertyName(String key, StringBuilder replaceBuilder) {
        for (int i = 0; i < DISALLOWED_IN_PROPERTY_NAME.length; ++i) {
            if (!key.contains(DISALLOWED_IN_PROPERTY_NAME[i])) continue;
            return DslJsonSerializer.replaceAll(key, DISALLOWED_IN_PROPERTY_NAME, "_", replaceBuilder);
        }
        return key;
    }

    private static CharSequence replaceAll(String s, String[] stringsToReplace, String replacement, StringBuilder replaceBuilder) {
        replaceBuilder.setLength(0);
        replaceBuilder.append(s);
        for (String toReplace : stringsToReplace) {
            DslJsonSerializer.replace(replaceBuilder, toReplace, replacement, 0);
        }
        return replaceBuilder;
    }

    static void replace(StringBuilder replaceBuilder, String toReplace, String replacement, int fromIndex) {
        int i = replaceBuilder.indexOf(toReplace, fromIndex);
        while (i != -1) {
            replaceBuilder.replace(i, i + toReplace.length(), replacement);
            fromIndex = i;
            i = replaceBuilder.indexOf(toReplace, fromIndex);
        }
    }

    private void serializeResponse(Response response) {
        if (response.hasContent()) {
            this.writeFieldName("response");
            this.jw.writeByte((byte)123);
            this.writeField("headers", response.getHeaders(), this.apmServerClient.supportsMultipleHeaderValues());
            this.writeField("finished", response.isFinished());
            this.writeField("headers_sent", response.isHeadersSent());
            this.writeFieldName("status_code");
            NumberConverter.serialize(response.getStatusCode(), this.jw);
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializeRequest(Request request) {
        if (request.hasContent()) {
            this.writeFieldName("request");
            this.jw.writeByte((byte)123);
            this.writeField("method", request.getMethod());
            this.writeField("headers", request.getHeaders(), this.apmServerClient.supportsMultipleHeaderValues());
            this.writeField("cookies", request.getCookies(), this.apmServerClient.supportsMultipleHeaderValues());
            if (!request.getFormUrlEncodedParameters().isEmpty()) {
                this.writeField("body", request.getFormUrlEncodedParameters(), true);
            } else if (request.getRawBody() != null) {
                this.writeField("body", request.getRawBody());
            } else {
                CharSequence bodyBuffer = request.getBodyBufferForSerialization();
                if (bodyBuffer != null && bodyBuffer.length() > 0) {
                    this.writeFieldName("body");
                    this.jw.writeString(bodyBuffer);
                    this.jw.writeByte((byte)44);
                }
            }
            if (request.getUrl().hasContent()) {
                this.writeFieldName("url");
                this.serializeUrl(request.getUrl());
                this.jw.writeByte((byte)44);
            }
            if (request.getSocket().hasContent()) {
                this.serializeSocket(request.getSocket());
            }
            this.writeLastField("http_version", request.getHttpVersion());
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)44);
        }
    }

    void serializeUrl(Url url) {
        this.jw.writeByte((byte)123);
        this.writeField("full", url.getFull());
        this.writeField("hostname", url.getHostname());
        int port = url.getPort();
        if (this.apmServerClient.supportsNumericUrlPort()) {
            this.writeField("port", port);
        } else {
            DslJsonSerializer.writeFieldName("port", this.jw);
            this.jw.writeByte((byte)34);
            NumberConverter.serialize(port, this.jw);
            this.jw.writeByte((byte)34);
            this.jw.writeByte((byte)44);
        }
        this.writeField("pathname", url.getPathname());
        this.writeField("search", url.getSearch());
        this.writeLastField("protocol", url.getProtocol());
        this.jw.writeByte((byte)125);
    }

    private void serializeSocket(Socket socket) {
        this.writeFieldName("socket");
        this.jw.writeByte((byte)123);
        this.writeLastField("remote_address", socket.getRemoteAddress());
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    private void writeField(String fieldName, PotentiallyMultiValuedMap map, boolean supportsMultipleValues) {
        if (map.isEmpty()) {
            return;
        }
        this.writeFieldName(fieldName);
        this.jw.writeByte((byte)123);
        int size = map.size();
        if (supportsMultipleValues) {
            this.serializePotentiallyMultiValuedEntry(map.getKey(0), map.getValue(0));
            for (int i = 1; i < size; ++i) {
                this.jw.writeByte((byte)44);
                this.serializePotentiallyMultiValuedEntry(map.getKey(i), map.getValue(i));
            }
        } else {
            int last = size - 1;
            for (int i = 0; i <= last; ++i) {
                String key = map.getKey(i);
                String value = map.getFirst(key);
                if (i == last) {
                    this.writeLastField(key, value);
                    continue;
                }
                this.writeField(key, value);
            }
        }
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    private void serializePotentiallyMultiValuedEntry(String key, @Nullable Object value) {
        this.jw.writeString(key);
        this.jw.writeByte((byte)58);
        if (value instanceof String) {
            StringConverter.serialize((String)value, this.jw);
        } else if (value instanceof List) {
            this.jw.writeByte((byte)91);
            List values = (List)value;
            this.jw.writeString((String)values.get(0));
            for (int i = 1; i < values.size(); ++i) {
                this.jw.writeByte((byte)44);
                this.jw.writeString((String)values.get(i));
            }
            this.jw.writeByte((byte)93);
        } else if (value == null) {
            this.jw.writeNull();
        }
    }

    private void serializeUser(User user) {
        this.writeFieldName("user");
        this.jw.writeByte((byte)123);
        this.writeField("domain", user.getDomain());
        this.writeField("id", user.getId());
        this.writeField("email", user.getEmail());
        this.writeLastField("username", user.getUsername());
        this.jw.writeByte((byte)125);
    }

    void writeEmptyField(String fieldName) {
        this.writeFieldName(fieldName);
        this.writeStringValue("");
        this.jw.writeByte((byte)44);
    }

    void writeField(String fieldName, StringBuilder value) {
        if (value.length() > 0) {
            this.writeFieldName(fieldName);
            this.writeStringBuilderValue(value);
            this.jw.writeByte((byte)44);
        }
    }

    void writeLongStringField(String fieldName, @Nullable CharSequence value) {
        if (value != null) {
            this.writeFieldName(fieldName);
            this.writeLongStringValue(value);
            this.jw.writeByte((byte)44);
        }
    }

    void writeField(String fieldName, @Nullable CharSequence value) {
        DslJsonSerializer.writeField(fieldName, value, this.replaceBuilder, this.jw);
    }

    static void writeField(String fieldName, @Nullable CharSequence value, StringBuilder replaceBuilder, JsonWriter jw) {
        DslJsonSerializer.writeField(fieldName, value, replaceBuilder, jw, false);
    }

    static void writeField(String fieldName, @Nullable CharSequence value, StringBuilder replaceBuilder, JsonWriter jw, boolean writeNull) {
        if (value == null) {
            if (writeNull) {
                DslJsonSerializer.writeFieldName(fieldName, jw);
                jw.writeNull();
                jw.writeByte((byte)44);
            }
        } else {
            DslJsonSerializer.writeFieldName(fieldName, jw);
            DslJsonSerializer.writeStringValue(value, replaceBuilder, jw);
            jw.writeByte((byte)44);
        }
    }

    private void writeStringBuilderValue(StringBuilder value) {
        DslJsonSerializer.writeStringBuilderValue(value, this.jw);
    }

    private static void writeStringBuilderValue(StringBuilder value, JsonWriter jw) {
        if (value.length() > 1024) {
            value.setLength(1023);
            value.append('\u2026');
        }
        jw.writeString(value);
    }

    private void writeStringValue(CharSequence value) {
        DslJsonSerializer.writeStringValue(value, this.replaceBuilder, this.jw);
    }

    public static void writeStringValue(CharSequence value, StringBuilder replaceBuilder, JsonWriter jw) {
        if (value.length() > 1024) {
            replaceBuilder.setLength(0);
            replaceBuilder.append(value, 0, Math.min(value.length(), 1025));
            DslJsonSerializer.writeStringBuilderValue(replaceBuilder, jw);
        } else {
            jw.writeString(value);
        }
    }

    private static void writeLongStringBuilderValue(StringBuilder value, JsonWriter jw) {
        if (value.length() > 10000) {
            value.setLength(9999);
            value.append('\u2026');
        }
        jw.writeString(value);
    }

    private void writeLongStringValue(CharSequence value) {
        DslJsonSerializer.writeLongStringValue(value, this.replaceBuilder, this.jw);
    }

    private static void writeLongStringValue(CharSequence value, StringBuilder replaceBuilder, JsonWriter jw) {
        if (value.length() > 10000) {
            replaceBuilder.setLength(0);
            replaceBuilder.append(value, 0, Math.min(value.length(), 10001));
            DslJsonSerializer.writeLongStringBuilderValue(replaceBuilder, jw);
        } else {
            jw.writeString(value);
        }
    }

    static void writeField(String fieldName, long value, JsonWriter jw) {
        DslJsonSerializer.writeFieldName(fieldName, jw);
        NumberConverter.serialize(value, jw);
        jw.writeByte((byte)44);
    }

    private void writeField(String fieldName, long value) {
        DslJsonSerializer.writeField(fieldName, value, this.jw);
    }

    private void writeField(String fieldName, int value) {
        this.writeFieldName(fieldName);
        NumberConverter.serialize(value, this.jw);
        this.jw.writeByte((byte)44);
    }

    private void writeLastField(String fieldName, int value) {
        this.writeFieldName(fieldName);
        NumberConverter.serialize(value, this.jw);
    }

    private void writeLastField(String fieldName, long value) {
        this.writeFieldName(fieldName);
        NumberConverter.serialize(value, this.jw);
    }

    private void writeField(String fieldName, boolean value) {
        this.writeFieldName(fieldName);
        BoolConverter.serialize(value, this.jw);
        this.jw.writeByte((byte)44);
    }

    private void writeLastField(String fieldName, boolean value) {
        this.writeFieldName(fieldName);
        BoolConverter.serialize(value, this.jw);
    }

    private void writeField(String fieldName, double value) {
        this.writeFieldName(fieldName);
        NumberConverter.serialize(value, this.jw);
        this.jw.writeByte((byte)44);
    }

    void writeLastField(String fieldName, @Nullable CharSequence value) {
        DslJsonSerializer.writeLastField(fieldName, value, this.replaceBuilder, this.jw);
    }

    public static void writeLastField(String fieldName, @Nullable CharSequence value, StringBuilder replaceBuilder, JsonWriter jw) {
        DslJsonSerializer.writeFieldName(fieldName, jw);
        if (value != null && value.length() > 0) {
            DslJsonSerializer.writeStringValue(value, replaceBuilder, jw);
        } else {
            jw.writeNull();
        }
    }

    public static void writeFieldName(String fieldName, JsonWriter jw) {
        jw.writeByte((byte)34);
        jw.writeAscii(fieldName);
        jw.writeByte((byte)34);
        jw.writeByte((byte)58);
    }

    private void writeFieldName(String fieldName) {
        DslJsonSerializer.writeFieldName(fieldName, this.jw);
    }

    static void writeField(String fieldName, List<String> values, JsonWriter jw) {
        if (values.size() > 0) {
            DslJsonSerializer.writeFieldName(fieldName, jw);
            jw.writeByte((byte)91);
            jw.writeString(values.get(0));
            for (int i = 1; i < values.size(); ++i) {
                jw.writeByte((byte)44);
                jw.writeString(values.get(i));
            }
            jw.writeByte((byte)93);
            jw.writeByte((byte)44);
        }
    }

    private void writeNonLastIdField(String fieldName, Id id) {
        this.writeIdField(fieldName, id);
        this.jw.writeByte((byte)44);
    }

    private void writeIdField(String fieldName, Id id) {
        this.writeFieldName(fieldName);
        this.jw.writeByte((byte)34);
        id.writeAsHex(this.jw);
        this.jw.writeByte((byte)34);
    }

    private void writeTimestamp(long epochMicros) {
        this.writeFieldName("timestamp");
        NumberConverter.serialize(epochMicros, this.jw);
        this.jw.writeByte((byte)44);
    }

    private void writeHexArray(String fieldName, @Nullable LongList longList) {
        if (longList != null && longList.getSize() > 0) {
            this.writeFieldName(fieldName);
            this.jw.writeByte((byte)91);
            int size = longList.getSize();
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    this.jw.writeByte((byte)44);
                }
                this.jw.writeByte((byte)34);
                HexUtils.writeAsHex(longList.get(i), this.jw);
                this.jw.writeByte((byte)34);
            }
            this.jw.writeByte((byte)93);
            this.jw.writeByte((byte)44);
        }
    }
}

