/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.report;

import co.elastic.apm.agent.report.AbstractIntakeApiHandler;
import co.elastic.apm.agent.report.ApmServerClient;
import co.elastic.apm.agent.report.ApmServerReporter;
import co.elastic.apm.agent.report.ReporterConfiguration;
import co.elastic.apm.agent.report.ReportingEvent;
import co.elastic.apm.agent.report.ReportingEventHandler;
import co.elastic.apm.agent.report.processor.ProcessorEventHandler;
import co.elastic.apm.agent.report.serialize.PayloadSerializer;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.util.ExecutorUtils;
import java.net.HttpURLConnection;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

public class IntakeV2ReportingEventHandler
extends AbstractIntakeApiHandler
implements ReportingEventHandler {
    public static final String INTAKE_V2_URL = "/intake/v2/events";
    public static final String INTAKE_V2_FLUSH_URL = "/intake/v2/events?flushed=true";
    private final ProcessorEventHandler processorEventHandler;
    private final ScheduledExecutorService timeoutTimer;
    @Nullable
    private Runnable timeoutTask;
    private final AtomicLong processed = new AtomicLong();
    private static final Logger logger = LoggerFactory.getLogger(IntakeV2ReportingEventHandler.class);

    public IntakeV2ReportingEventHandler(ReporterConfiguration reporterConfiguration, ProcessorEventHandler processorEventHandler, PayloadSerializer payloadSerializer, ApmServerClient apmServerClient) {
        super(reporterConfiguration, payloadSerializer, apmServerClient);
        this.processorEventHandler = processorEventHandler;
        this.timeoutTimer = ExecutorUtils.createSingleThreadSchedulingDaemonPool("request-timeout-timer");
    }

    @Override
    public void init(ApmServerReporter reporter) {
        this.timeoutTask = new WakeupOnTimeout(reporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(ReportingEvent event, long sequence, boolean endOfBatch) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Receiving {} event (sequence {})", (Object)event.getType(), (Object)sequence);
        }
        try {
            if (!this.shutDown) {
                if (this.connection != null && this.isApiRequestTimeExpired()) {
                    logger.debug("Request flush because the request timeout occurred");
                    this.endRequest();
                }
                this.dispatchEvent(event, sequence, endOfBatch);
            }
        }
        finally {
            this.processed.set(sequence);
            event.end();
            event.resetState();
        }
    }

    @Override
    public boolean isProcessed(long sequence) {
        return this.processed.get() >= sequence;
    }

    private void dispatchEvent(ReportingEvent event, long sequence, boolean endOfBatch) throws Exception {
        if (event.getType() == null) {
            return;
        }
        switch (event.getType()) {
            case MAKE_FLUSH_REQUEST: {
                this.endRequest();
                this.connection = this.startRequest(INTAKE_V2_FLUSH_URL);
            }
            case END_REQUEST: {
                this.endRequest();
                break;
            }
            case SHUTDOWN: {
                this.handleShutdownEvent();
                break;
            }
            case SPAN: 
            case ERROR: 
            case TRANSACTION: 
            case JSON_WRITER: {
                this.handleIntakeEvent(event, sequence, endOfBatch);
            }
        }
    }

    private void handleShutdownEvent() {
        this.shutDown = true;
        this.endRequest();
    }

    private void handleIntakeEvent(ReportingEvent event, long sequence, boolean endOfBatch) {
        this.processorEventHandler.onEvent(event, sequence, endOfBatch);
        try {
            if (this.connection == null) {
                this.connection = this.startRequest(INTAKE_V2_URL);
            }
            if (this.connection != null) {
                this.writeEvent(event);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to get APM server connection, dropping event: {}", (Object)event);
                }
                ++this.dropped;
            }
        }
        catch (Exception e) {
            this.handleConnectionError(event, e);
        }
        if (this.shouldEndRequest()) {
            this.endRequest();
        }
    }

    private void handleConnectionError(ReportingEvent event, Exception e) {
        logger.error("Failed to handle event of type {} with this error: {}", (Object)event.getType(), (Object)e.getMessage());
        logger.debug("Event handling failure", e);
        this.endRequest();
        this.onConnectionError(null, this.currentlyTransmitting + 1L, 0L);
    }

    int getBufferSize() {
        return this.payloadSerializer.getBufferSize();
    }

    private void writeEvent(ReportingEvent event) {
        if (event.getTransaction() != null) {
            ++this.currentlyTransmitting;
            this.payloadSerializer.serializeTransactionNdJson(event.getTransaction());
        } else if (event.getSpan() != null) {
            ++this.currentlyTransmitting;
            this.payloadSerializer.serializeSpanNdJson(event.getSpan());
        } else if (event.getError() != null) {
            ++this.currentlyTransmitting;
            this.payloadSerializer.serializeErrorNdJson(event.getError());
        } else if (event.getJsonWriter() != null) {
            this.payloadSerializer.writeBytes(event.getJsonWriter().getByteBuffer(), event.getJsonWriter().size());
        }
    }

    @Override
    @Nullable
    protected HttpURLConnection startRequest(String endpoint) throws Exception {
        HttpURLConnection connection = super.startRequest(endpoint);
        if (connection != null && this.timeoutTask != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Scheduling request timeout in {}", (Object)this.reporterConfiguration.getApiRequestTime());
            }
            this.timeoutTimer.schedule(this.timeoutTask, this.reporterConfiguration.getApiRequestTime().getMillis(), TimeUnit.MILLISECONDS);
        }
        return connection;
    }

    @Override
    public void close() {
        super.close();
        logger.info("Reported events: {}", (Object)this.reported);
        logger.info("Dropped events: {}", (Object)this.dropped);
        this.timeoutTimer.shutdownNow();
    }

    private static class WakeupOnTimeout
    implements Runnable {
        private final ApmServerReporter reporter;

        private WakeupOnTimeout(ApmServerReporter reporter) {
            this.reporter = reporter;
        }

        @Override
        public void run() {
            try {
                this.reporter.scheduleWakeupEvent();
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), e);
            }
        }
    }
}

