/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.report;

import co.elastic.apm.agent.common.ThreadUtils;
import co.elastic.apm.agent.impl.error.ErrorCapture;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.report.Reporter;
import co.elastic.apm.agent.report.ReporterConfiguration;
import co.elastic.apm.agent.report.ReportingEvent;
import co.elastic.apm.agent.report.ReportingEventHandler;
import co.elastic.apm.agent.report.disruptor.ExponentionallyIncreasingSleepingWaitStrategy;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.util.MathUtils;
import com.dslplatform.json.JsonWriter;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventTranslator;
import com.lmax.disruptor.EventTranslatorOneArg;
import com.lmax.disruptor.IgnoreExceptionHandler;
import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import javax.annotation.Nullable;

public class ApmServerReporter
implements Reporter {
    private static final Logger logger = LoggerFactory.getLogger(ApmServerReporter.class);
    private static final EventTranslatorOneArg<ReportingEvent, Transaction> TRANSACTION_EVENT_TRANSLATOR = new EventTranslatorOneArg<ReportingEvent, Transaction>(){

        @Override
        public void translateTo(ReportingEvent event, long sequence, Transaction t) {
            event.setTransaction(t);
        }
    };
    private static final EventTranslatorOneArg<ReportingEvent, Span> SPAN_EVENT_TRANSLATOR = new EventTranslatorOneArg<ReportingEvent, Span>(){

        @Override
        public void translateTo(ReportingEvent event, long sequence, Span s) {
            event.setSpan(s);
        }
    };
    private static final EventTranslatorOneArg<ReportingEvent, Thread> END_REQUEST_EVENT_TRANSLATOR = new EventTranslatorOneArg<ReportingEvent, Thread>(){

        @Override
        public void translateTo(ReportingEvent event, long sequence, @Nullable Thread unparkAfterProcessed) {
            event.setEndRequestEvent();
            event.unparkAfterProcessed(unparkAfterProcessed);
        }
    };
    private static final EventTranslatorOneArg<ReportingEvent, Thread> MAKE_FLUSH_REQUEST_EVENT_TRANSLATOR = new EventTranslatorOneArg<ReportingEvent, Thread>(){

        @Override
        public void translateTo(ReportingEvent event, long sequence, @Nullable Thread unparkAfterProcessed) {
            event.setMakeFlushRequestEvent();
            event.unparkAfterProcessed(unparkAfterProcessed);
        }
    };
    private static final EventTranslator<ReportingEvent> WAKEUP_EVENT_TRANSLATOR = new EventTranslator<ReportingEvent>(){

        @Override
        public void translateTo(ReportingEvent event, long sequence) {
            event.setWakeupEvent();
        }
    };
    private static final EventTranslatorOneArg<ReportingEvent, ErrorCapture> ERROR_EVENT_TRANSLATOR = new EventTranslatorOneArg<ReportingEvent, ErrorCapture>(){

        @Override
        public void translateTo(ReportingEvent event, long sequence, ErrorCapture error) {
            event.setError(error);
        }
    };
    private static final EventTranslatorOneArg<ReportingEvent, JsonWriter> JSON_WRITER_EVENT_TRANSLATOR = new EventTranslatorOneArg<ReportingEvent, JsonWriter>(){

        @Override
        public void translateTo(ReportingEvent event, long sequence, JsonWriter jsonWriter) {
            event.setJsonWriter(jsonWriter);
        }
    };
    private static final EventTranslatorOneArg<ReportingEvent, Thread> SHUTDOWN_EVENT_TRANSLATOR = new EventTranslatorOneArg<ReportingEvent, Thread>(){

        @Override
        public void translateTo(ReportingEvent event, long sequence, @Nullable Thread unparkAfterProcessed) {
            event.shutdownEvent();
            event.unparkAfterProcessed(Thread.currentThread());
        }
    };
    private final Disruptor<ReportingEvent> disruptor;
    private final AtomicLong dropped = new AtomicLong();
    private final boolean dropTransactionIfQueueFull;
    private final ReportingEventHandler reportingEventHandler;
    private final boolean syncReport;

    public ApmServerReporter(boolean dropTransactionIfQueueFull, ReporterConfiguration reporterConfiguration, ReportingEventHandler reportingEventHandler) {
        this.dropTransactionIfQueueFull = dropTransactionIfQueueFull;
        this.syncReport = reporterConfiguration.isReportSynchronously();
        this.disruptor = new Disruptor<ReportingEvent>(new TransactionEventFactory(), MathUtils.getNextPowerOf2(reporterConfiguration.getMaxQueueSize()), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                thread.setName(ThreadUtils.addElasticApmThreadPrefix("server-reporter"));
                return thread;
            }
        }, ProducerType.MULTI, (WaitStrategy)new ExponentionallyIncreasingSleepingWaitStrategy(100000, 10000000));
        this.reportingEventHandler = reportingEventHandler;
        this.disruptor.setDefaultExceptionHandler(new IgnoreExceptionHandler());
        this.disruptor.handleEventsWith(this.reportingEventHandler);
    }

    @Override
    public void start() {
        this.disruptor.start();
        this.reportingEventHandler.init(this);
    }

    @Override
    public void report(Transaction transaction) {
        if (!this.tryAddEventToRingBuffer(transaction, TRANSACTION_EVENT_TRANSLATOR)) {
            transaction.decrementReferences();
        }
        if (this.syncReport) {
            this.flush();
        }
    }

    @Override
    public void report(Span span) {
        if (!this.tryAddEventToRingBuffer(span, SPAN_EVENT_TRANSLATOR)) {
            span.decrementReferences();
        }
        if (this.syncReport) {
            this.flush();
        }
    }

    @Override
    public boolean flush() {
        return this.flush(-1L, TimeUnit.NANOSECONDS, false);
    }

    @Override
    public long getDropped() {
        return this.dropped.get() + this.reportingEventHandler.getDropped();
    }

    @Override
    public long getReported() {
        return this.reportingEventHandler.getReported();
    }

    public void scheduleWakeupEvent() {
        this.disruptor.getRingBuffer().tryPublishEvent(WAKEUP_EVENT_TRANSLATOR);
    }

    @Override
    public boolean flush(long timeout, TimeUnit unit, boolean followupWithFlushRequest) {
        if (followupWithFlushRequest) {
            return this.publishAndWaitForEvent(timeout, unit, MAKE_FLUSH_REQUEST_EVENT_TRANSLATOR);
        }
        return this.publishAndWaitForEvent(timeout, unit, END_REQUEST_EVENT_TRANSLATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean publishAndWaitForEvent(long timeout, TimeUnit unit, EventTranslatorOneArg<ReportingEvent, Thread> eventTranslator) {
        if (!this.reportingEventHandler.isHealthy()) {
            return false;
        }
        ReportingEventHandler reportingEventHandler = this.reportingEventHandler;
        long startNs = System.nanoTime();
        long thresholdNs = timeout < 0L ? Long.MAX_VALUE : unit.toNanos(timeout) + startNs;
        while (true) {
            try {
                long sequence = this.disruptor.getRingBuffer().tryNext();
                try {
                    eventTranslator.translateTo(this.disruptor.get(sequence), sequence, Thread.currentThread());
                }
                finally {
                    this.disruptor.getRingBuffer().publish(sequence);
                }
                return this.waitForEventProcessed(sequence, thresholdNs);
            }
            catch (InsufficientCapacityException e) {
                LockSupport.parkNanos(100000L);
                if (!Thread.currentThread().isInterrupted() && System.nanoTime() < thresholdNs && reportingEventHandler.isHealthy()) continue;
                return false;
            }
            break;
        }
    }

    private boolean waitForEventProcessed(long sequence, long thresholdNs) {
        ReportingEventHandler reportingEventHandler = this.reportingEventHandler;
        long nowNs = System.nanoTime();
        while (nowNs < thresholdNs && reportingEventHandler.isHealthy() && !reportingEventHandler.isProcessed(sequence)) {
            int minPeriodicWakeupNs = 10000000;
            LockSupport.parkNanos(Math.min((long)minPeriodicWakeupNs, thresholdNs - nowNs));
            if (Thread.currentThread().isInterrupted()) break;
            nowNs = System.nanoTime();
        }
        return reportingEventHandler.isProcessed(sequence);
    }

    @Override
    public void close() {
        logger.info("dropped events because of full queue: {}", (Object)this.dropped.get());
        this.publishAndWaitForEvent(5L, TimeUnit.SECONDS, SHUTDOWN_EVENT_TRANSLATOR);
        this.reportingEventHandler.close();
        try {
            this.disruptor.shutdown(1L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            logger.warn("Timeout while shutting down disruptor");
        }
    }

    @Override
    public void report(ErrorCapture error) {
        if (!this.tryAddEventToRingBuffer(error, ERROR_EVENT_TRANSLATOR)) {
            error.recycle();
        }
        if (this.syncReport) {
            this.flush();
        }
    }

    @Override
    public void report(JsonWriter jsonWriter) {
        if (jsonWriter.size() == 0) {
            return;
        }
        this.tryAddEventToRingBuffer(jsonWriter, JSON_WRITER_EVENT_TRANSLATOR);
        if (this.syncReport) {
            this.flush();
        }
    }

    private <E> boolean tryAddEventToRingBuffer(E event, EventTranslatorOneArg<ReportingEvent, E> eventTranslator) {
        if (this.dropTransactionIfQueueFull) {
            boolean queueFull;
            boolean bl = queueFull = !this.disruptor.getRingBuffer().tryPublishEvent(eventTranslator, event);
            if (queueFull) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Could not add {} {} to ring buffer as no slots are available", (Object)event.getClass().getSimpleName(), (Object)event);
                }
                this.dropped.incrementAndGet();
                return false;
            }
        } else {
            this.disruptor.getRingBuffer().publishEvent(eventTranslator, event);
        }
        return true;
    }

    static class TransactionEventFactory
    implements EventFactory<ReportingEvent> {
        TransactionEventFactory() {
        }

        @Override
        public ReportingEvent newInstance() {
            return new ReportingEvent();
        }
    }
}

