/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.rabbitmq;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.rabbitmq.AbstractBaseInstrumentation;
import co.elastic.apm.agent.rabbitmq.header.SpringRabbitMQTextHeaderGetter;
import javax.annotation.Nullable;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;

public class SpringAmqpTransactionHelper {
    private final ElasticApmTracer tracer;

    public SpringAmqpTransactionHelper(ElasticApmTracer tracer) {
        this.tracer = tracer;
    }

    @Nullable
    public Transaction createTransaction(Message message, String transactionNamePrefix) {
        String exchange = null;
        MessageProperties messageProperties = message.getMessageProperties();
        if (messageProperties != null) {
            exchange = messageProperties.getReceivedExchange();
        }
        if (exchange != null && AbstractBaseInstrumentation.isIgnored(exchange)) {
            return null;
        }
        Transaction transaction = this.tracer.currentTransaction();
        if (transaction != null) {
            return null;
        }
        transaction = this.tracer.startChildTransaction(messageProperties, SpringRabbitMQTextHeaderGetter.INSTANCE, message.getClass().getClassLoader());
        if (transaction == null) {
            return null;
        }
        ((Transaction)((Transaction)((Transaction)transaction.withType("messaging")).withName(transactionNamePrefix)).appendToName(" RECEIVE from ")).appendToName(AbstractBaseInstrumentation.normalizeExchangeName(exchange));
        transaction.setFrameworkName("Spring AMQP");
        if (messageProperties != null) {
            long timestamp = AbstractBaseInstrumentation.getTimestamp(messageProperties.getTimestamp());
            String receivedRoutingKey = messageProperties.getReceivedRoutingKey();
            transaction.getContext().getMessage().withAge(timestamp).withRoutingKey(receivedRoutingKey);
        }
        if (exchange != null) {
            transaction.getContext().getMessage().withQueue(exchange);
        }
        AbstractBaseInstrumentation.captureHeaders(messageProperties != null ? messageProperties.getHeaders() : null, transaction.getContext().getMessage());
        return (Transaction)transaction.activate();
    }
}

