/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.rabbitmq;

import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.rabbitmq.SpringAmqpTransactionNameUtil;
import co.elastic.apm.agent.rabbitmq.SpringBaseInstrumentation;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;

public class SpringAmqpMessageListenerInstrumentation
extends SpringBaseInstrumentation {
    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return ElementMatchers.not(ElementMatchers.isBootstrapClassLoader()).and(CustomElementMatchers.classLoaderCanLoadClass("org.springframework.amqp.core.MessageListener"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.named("org.springframework.amqp.core.MessageListener")));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("onMessage").and(ElementMatchers.takesArgument(0, ElementMatchers.hasSuperType(ElementMatchers.named("org.springframework.amqp.core.Message")))).and(ElementMatchers.isPublic());
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.rabbitmq.SpringAmqpMessageListenerInstrumentation$SpringAmqpMessageListenerAdvice";
    }

    public static class SpringAmqpMessageListenerAdvice
    extends SpringBaseInstrumentation.BaseAdvice {
        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object beforeMessageHandle(@Advice.This MessageListener listener, @Advice.Argument(value=0) @Nullable Message message) {
            if (message == null) {
                return null;
            }
            return transactionHelper.createTransaction(message, SpringAmqpTransactionNameUtil.getTransactionNamePrefix(listener));
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class, inline=false)
        public static void afterMessageHandle(@Advice.Enter @Nullable Object transactionObject, @Advice.Thrown @Nullable Throwable throwable) {
            if (transactionObject instanceof Transaction) {
                Transaction transaction = (Transaction)transactionObject;
                ((Transaction)((Transaction)transaction.captureException(throwable)).deactivate()).end();
            }
        }
    }
}

