/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.rabbitmq;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.rabbitmq.AbstractBaseInstrumentation;
import co.elastic.apm.agent.rabbitmq.ConsumerInstrumentation;
import co.elastic.apm.agent.rabbitmq.RabbitmqBaseInstrumentation;
import co.elastic.apm.agent.rabbitmq.header.RabbitMQTextHeaderGetter;
import co.elastic.apm.agent.rabbitmq.header.RabbitMQTextHeaderSetter;
import co.elastic.apm.agent.sdk.DynamicTransformer;
import co.elastic.apm.agent.sdk.ElasticApmInstrumentation;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.GetResponse;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class ChannelInstrumentation
extends RabbitmqBaseInstrumentation {
    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameStartsWith("com.rabbitmq.client").and(ElementMatchers.nameContains("Channel"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("com.rabbitmq.client.Channel"));
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return ElementMatchers.not(ElementMatchers.isBootstrapClassLoader()).and(CustomElementMatchers.classLoaderCanLoadClass("com.rabbitmq.client.Channel"));
    }

    public static class RabbitMqHelper {
        @Nullable
        public static Span createExitSpan(@Nullable String exchangeOrQueue) {
            AbstractSpan<?> context = TracerAwareInstrumentation.tracer.getActive();
            if (exchangeOrQueue == null || context == null || AbstractBaseInstrumentation.isIgnored(exchangeOrQueue)) {
                return null;
            }
            Span exitSpan = context.createExitSpan();
            if (exitSpan == null) {
                return null;
            }
            return ((Span)((Span)exitSpan.activate()).withType("messaging")).withSubtype("rabbitmq");
        }

        public static void captureDestination(String exchange, InetAddress brokerAddress, int port, Span span) {
            span.getContext().getDestination().withInetAddress(brokerAddress).withPort(port);
            span.getContext().getServiceTarget().withType("rabbitmq").withName(exchange);
        }
    }

    public static class BasicGet
    extends ChannelInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("basicGet").and(ElementMatchers.takesArgument(0, String.class));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Object onEnter(@Advice.Argument(value=0) @Nullable String queue) {
                if (!TracerAwareInstrumentation.tracer.isRunning()) {
                    return null;
                }
                return RabbitMqHelper.createExitSpan(AbstractBaseInstrumentation.normalizeQueueName(queue));
            }

            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
            public static void onExit(@Advice.This Channel channel, @Advice.Argument(value=0) String queue, @Advice.Enter @Nullable Object objSpan, @Advice.Return @Nullable GetResponse rv, @Advice.Thrown @Nullable Throwable thrown) {
                if (!(objSpan instanceof Span)) {
                    return;
                }
                Span span = (Span)objSpan;
                if (AbstractBaseInstrumentation.isIgnored(queue)) {
                    span.requestDiscarding();
                }
                ((Span)span.withAction("poll").withName("RabbitMQ POLL from ")).appendToName(AbstractBaseInstrumentation.normalizeQueueName(queue));
                Envelope envelope = null;
                AMQP.BasicProperties properties = null;
                if (rv != null) {
                    envelope = rv.getEnvelope();
                    properties = rv.getProps();
                }
                String exchange = null != envelope ? envelope.getExchange() : null;
                if (AbstractBaseInstrumentation.isIgnored(exchange = AbstractBaseInstrumentation.normalizeExchangeName(exchange))) {
                    span.requestDiscarding();
                }
                AbstractBaseInstrumentation.captureMessage(queue, envelope != null ? envelope.getRoutingKey() : null, AbstractBaseInstrumentation.getTimestamp(properties != null ? properties.getTimestamp() : null), span);
                Connection connection = channel.getConnection();
                RabbitMqHelper.captureDestination(exchange, connection.getAddress(), connection.getPort(), span);
                if (properties != null) {
                    span.addSpanLink(TraceContext.getFromTraceContextTextHeaders(), RabbitMQTextHeaderGetter.INSTANCE, properties);
                }
                ((Span)((Span)span.captureException(thrown)).deactivate()).end();
            }
        }
    }

    public static class BasicPublish
    extends ChannelInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("basicPublish").and(ElementMatchers.takesArguments(6));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            @Advice.AssignReturned.ToArguments(value={@Advice.AssignReturned.ToArguments.ToArgument(index=0, value=4, typing=Assigner.Typing.DYNAMIC)})
            public static Object[] onBasicPublish(@Advice.This Channel channel, @Advice.Argument(value=0) @Nullable String exchange, @Advice.Argument(value=1) @Nullable String routingKey, @Advice.Argument(value=4) @Nullable AMQP.BasicProperties properties) {
                if (!TracerAwareInstrumentation.tracer.isRunning()) {
                    return null;
                }
                Span exitSpan = RabbitMqHelper.createExitSpan(exchange);
                if (exitSpan == null) {
                    return null;
                }
                exchange = AbstractBaseInstrumentation.normalizeExchangeName(exchange);
                ((Span)exitSpan.withAction("send").withName("RabbitMQ SEND to ")).appendToName(exchange);
                properties = AdviceClass.propagateTraceContext(exitSpan, properties);
                AbstractBaseInstrumentation.captureMessage(exchange, routingKey, AbstractBaseInstrumentation.getTimestamp(properties.getTimestamp()), exitSpan);
                Connection connection = channel.getConnection();
                RabbitMqHelper.captureDestination(exchange, connection.getAddress(), connection.getPort(), exitSpan);
                return new Object[]{properties, exitSpan};
            }

            private static AMQP.BasicProperties propagateTraceContext(Span exitSpan, @Nullable AMQP.BasicProperties originalBasicProperties) {
                HashMap currentHeaders;
                AMQP.BasicProperties properties = originalBasicProperties;
                if (properties == null) {
                    properties = new AMQP.BasicProperties();
                }
                if ((currentHeaders = properties.getHeaders()) == null) {
                    currentHeaders = new HashMap();
                }
                HashMap headersWithContext = new HashMap(currentHeaders);
                exitSpan.propagateTraceContext(headersWithContext, RabbitMQTextHeaderSetter.INSTANCE);
                return properties.builder().headers(headersWithContext).build();
            }

            @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class, inline=false)
            public static void afterBasicPublish(@Advice.Enter @Nullable Object[] enterArray, @Advice.Thrown @Nullable Throwable throwable) {
                if (enterArray != null && enterArray.length >= 2 && enterArray[1] != null) {
                    Span span = (Span)enterArray[1];
                    ((Span)((Span)span.captureException(throwable)).deactivate()).end();
                }
            }
        }
    }

    public static class BasicConsume
    extends ChannelInstrumentation {
        public static final Collection<Class<? extends ElasticApmInstrumentation>> CONSUMER_INSTRUMENTATION = Collections.singleton(ConsumerInstrumentation.class);

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("basicConsume").and(ElementMatchers.takesArguments(7)).and(ElementMatchers.takesArgument(6, ElementMatchers.named("com.rabbitmq.client.Consumer")));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void onEnter(@Advice.This Channel channel, @Advice.Argument(value=6) @Nullable Consumer consumer) {
                if (consumer == null) {
                    return;
                }
                DynamicTransformer.ensureInstrumented(consumer.getClass(), CONSUMER_INSTRUMENTATION);
            }
        }
    }
}

