/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.rabbitmq;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.configuration.MessagingConfiguration;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.context.Message;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class AbstractBaseInstrumentation
extends TracerAwareInstrumentation {
    private static final CoreConfiguration coreConfiguration = GlobalTracer.requireTracerImpl().getConfig(CoreConfiguration.class);
    private static final MessagingConfiguration messagingConfiguration = GlobalTracer.requireTracerImpl().getConfig(MessagingConfiguration.class);

    protected static boolean isIgnored(String name) {
        return WildcardMatcher.isAnyMatch(messagingConfiguration.getIgnoreMessageQueues(), name);
    }

    protected static boolean isCaptureHeaders() {
        return coreConfiguration.isCaptureHeaders();
    }

    protected static boolean captureHeaderKey(String key) {
        return !WildcardMatcher.isAnyMatch(coreConfiguration.getSanitizeFieldNames(), key);
    }

    protected static Message captureMessage(String queueOrExchange, @Nullable String routingKey, long age, AbstractSpan<?> context) {
        return context.getContext().getMessage().withQueue(queueOrExchange).withRoutingKey(routingKey).withAge(age);
    }

    protected static long getTimestamp(@Nullable Date timestamp) {
        long age = -1L;
        if (timestamp != null) {
            long now = System.currentTimeMillis();
            long time = timestamp.getTime();
            age = time <= now ? now - time : 0L;
        }
        return age;
    }

    protected static void captureHeaders(@Nullable Map<String, Object> headers, Message message) {
        if (!AbstractBaseInstrumentation.isCaptureHeaders() || headers == null || headers.size() <= 0) {
            return;
        }
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            if (!AbstractBaseInstrumentation.captureHeaderKey(entry.getKey())) continue;
            message.addHeader(entry.getKey(), String.valueOf(entry.getValue()));
        }
    }

    protected static String normalizeExchangeName(@Nullable String exchange) {
        if (exchange == null) {
            return "<unknown>";
        }
        if (exchange.isEmpty()) {
            return "<default>";
        }
        return exchange;
    }

    protected static String normalizeQueueName(@Nullable String queue) {
        if (queue == null) {
            return "<unknown>";
        }
        if (queue.startsWith("amq.gen-")) {
            return "amq.gen-*";
        }
        return queue;
    }
}

