/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.profiler.asyncprofiler;

import co.elastic.apm.agent.common.JvmRuntimeInfo;
import co.elastic.apm.agent.common.util.ResourceExtractionUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;

public class AsyncProfiler {
    public static final String SAFEMODE_SYSTEM_PROPERTY_NAME = "AsyncProfiler.safemode";
    @Nullable
    private static volatile AsyncProfiler instance;

    private AsyncProfiler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AsyncProfiler getInstance(String profilerLibDirectory, int safemode) {
        AsyncProfiler result = instance;
        if (result != null) {
            return result;
        }
        Class<AsyncProfiler> clazz = AsyncProfiler.class;
        synchronized (AsyncProfiler.class) {
            if (instance == null) {
                if (JvmRuntimeInfo.ofCurrentVM().isJ9VM()) {
                    throw new IllegalStateException("OpenJ9 JVMs are not supported by async profiler. Please set profiling_inferred_spans_enabled to false");
                }
                try {
                    System.setProperty(SAFEMODE_SYSTEM_PROPERTY_NAME, String.valueOf(safemode));
                    AsyncProfiler.loadNativeLibrary(profilerLibDirectory);
                }
                catch (UnsatisfiedLinkError e) {
                    throw new IllegalStateException(String.format("It is likely that %s is not an executable location. Consider setting the profiling_inferred_spans_lib_directory property to a directory on a partition that allows execution", profilerLibDirectory), e);
                }
                instance = new AsyncProfiler();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reset() {
        Class<AsyncProfiler> clazz = AsyncProfiler.class;
        synchronized (AsyncProfiler.class) {
            instance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void loadNativeLibrary(String libraryDirectory) {
        String libraryName = AsyncProfiler.getLibraryFileName();
        Path file = ResourceExtractionUtil.extractResourceToDirectory("asyncprofiler/" + libraryName + ".so", libraryName, ".so", Paths.get(libraryDirectory, new String[0]));
        System.load(file.toString());
    }

    static String getLibraryFileName() {
        String os = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        if (os.contains("linux")) {
            if (arch.contains("arm") || arch.contains("aarch32")) {
                return "libasyncProfiler-linux-arm";
            }
            if (arch.contains("aarch")) {
                return "libasyncProfiler-linux-aarch64";
            }
            if (arch.contains("64")) {
                return "libasyncProfiler-linux-x64";
            }
            if (arch.contains("86")) {
                return "libasyncProfiler-linux-x86";
            }
            throw new IllegalStateException("Async-profiler does not work on Linux " + arch);
        }
        if (os.contains("mac")) {
            if (arch.contains("aarch")) {
                throw new IllegalStateException("Async-profiler 1.x does not work on Apple silicon");
            }
            return "libasyncProfiler-macos-x64";
        }
        throw new IllegalStateException("Async-profiler does not work on " + os);
    }

    public void stop() throws IllegalStateException {
        this.stop0();
    }

    public String execute(String command) throws IllegalArgumentException, IOException {
        return this.execute0(command);
    }

    public void enableProfilingThread(Thread thread) throws IllegalStateException {
        this.filterThread(thread, true);
    }

    public void disableProfilingThread(Thread thread) throws IllegalStateException {
        this.filterThread(thread, false);
    }

    public void enableProfilingCurrentThread() {
        this.filterThread0(null, true);
    }

    public void disableProfilingCurrentThread() throws IllegalStateException {
        this.filterThread0(null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterThread(Thread thread, boolean enable) throws IllegalStateException {
        Thread thread2 = thread;
        synchronized (thread2) {
            Thread.State state = thread.getState();
            if (state == Thread.State.NEW || state == Thread.State.TERMINATED) {
                return;
            }
            this.filterThread0(thread, enable);
        }
    }

    private native long getSamples();

    private native void start0(String var1, long var2, boolean var4) throws IllegalStateException;

    private native void stop0() throws IllegalStateException;

    private native String execute0(String var1) throws IllegalArgumentException, IOException;

    private native void filterThread0(Thread var1, boolean var2);
}

