/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.process;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.process.BaseProcessInstrumentation;
import co.elastic.apm.agent.process.ProcessHelper;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ProcessStartInstrumentation
extends BaseProcessInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("java.lang.ProcessBuilder");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("start").and(ElementMatchers.takesArguments(0));
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.process.ProcessStartInstrumentation$ProcessBuilderStartAdvice";
    }

    public static class ProcessBuilderStartAdvice {
        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onExit(@Advice.This ProcessBuilder processBuilder, @Advice.Return @Nullable Process process, @Advice.Thrown @Nullable Throwable t) {
            AbstractSpan<?> parentSpan = TracerAwareInstrumentation.tracer.getActive();
            if (parentSpan == null) {
                return;
            }
            if (t != null) {
                parentSpan.captureException(t);
            }
            if (process != null) {
                ProcessHelper.startProcess(parentSpan, process, processBuilder.command());
            }
        }
    }
}

