/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.pluginapi;

import co.elastic.apm.agent.impl.transaction.HeaderGetter;
import co.elastic.apm.agent.impl.transaction.TextHeaderGetter;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import java.lang.invoke.MethodHandle;
import java.util.Iterator;
import javax.annotation.Nullable;

public class HeadersExtractorBridge
implements TextHeaderGetter<Extractor> {
    private static final Logger logger = LoggerFactory.getLogger(HeadersExtractorBridge.class);
    @Nullable
    private static HeadersExtractorBridge INSTANCE;
    private final MethodHandle getFirstHeaderMethod;
    private final MethodHandle getAllHeadersMethod;

    public static HeadersExtractorBridge get(MethodHandle getFirstHeaderMethod, MethodHandle getAllHeadersMethod) {
        if (INSTANCE == null) {
            INSTANCE = new HeadersExtractorBridge(getFirstHeaderMethod, getAllHeadersMethod);
        }
        return INSTANCE;
    }

    private HeadersExtractorBridge(MethodHandle getFirstHeaderMethod, MethodHandle getAllHeadersMethod) {
        this.getFirstHeaderMethod = getFirstHeaderMethod;
        this.getAllHeadersMethod = getAllHeadersMethod;
    }

    @Override
    @Nullable
    public String getFirstHeader(String headerName, Extractor carrier) {
        if (carrier.headerExtractor != null) {
            try {
                return this.getFirstHeaderMethod.invoke(carrier.headerExtractor, headerName);
            }
            catch (Throwable throwable) {
                logger.error("Failed to extract trace context headers", throwable);
            }
        } else {
            Iterator<String> iterator;
            Iterable<String> headers = this.getValues(headerName, carrier);
            if (headers != null && (iterator = headers.iterator()).hasNext()) {
                return iterator.next();
            }
        }
        return null;
    }

    @Override
    public <S> void forEach(String headerName, Extractor carrier, S state, HeaderGetter.HeaderConsumer<String, S> consumer) {
        Iterable<String> values = this.getValues(headerName, carrier);
        if (values != null) {
            for (String value : values) {
                consumer.accept(value, state);
            }
        }
    }

    @Nullable
    public Iterable<String> getValues(String headerName, Extractor carrier) {
        Iterable values = null;
        try {
            values = this.getAllHeadersMethod.invoke(carrier.headersExtractor, headerName);
        }
        catch (Throwable throwable) {
            logger.error("Failed to extract trace context headers", throwable);
        }
        return values;
    }

    public static class Extractor {
        @Nullable
        private final Object headerExtractor;
        private final Object headersExtractor;

        private Extractor(@Nullable Object headerExtractor, Object headersExtractor) {
            this.headerExtractor = headerExtractor;
            this.headersExtractor = headersExtractor;
        }

        public static Extractor of(@Nullable Object headerExtractor, Object headersExtractor) {
            return new Extractor(headerExtractor, headersExtractor);
        }
    }
}

