/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.pluginapi;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.AnnotationValueOffsetMappingFactory;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.bci.bytebuddy.SimpleMethodSignatureOffsetMappingFactory;
import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class CaptureTransactionInstrumentation
extends TracerAwareInstrumentation {
    public static final Logger logger = LoggerFactory.getLogger(CaptureTransactionInstrumentation.class);
    private final CoreConfiguration coreConfig;
    private final StacktraceConfiguration stacktraceConfig;

    public CaptureTransactionInstrumentation(ElasticApmTracer tracer) {
        this.coreConfig = tracer.getConfig(CoreConfiguration.class);
        this.stacktraceConfig = tracer.getConfig(StacktraceConfiguration.class);
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return CustomElementMatchers.classLoaderCanLoadClass("co.elastic.apm.api.CaptureTransaction");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return CustomElementMatchers.isInAnyPackage(this.stacktraceConfig.getApplicationPackages(), ElementMatchers.none()).and(ElementMatchers.not(CustomElementMatchers.isProxy())).and(ElementMatchers.declaresMethod(this.getMethodMatcher()));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        if (this.coreConfig.isEnablePublicApiAnnotationInheritance()) {
            return CustomElementMatchers.overridesOrImplementsMethodThat(ElementMatchers.isAnnotatedWith(ElementMatchers.named("co.elastic.apm.api.CaptureTransaction")));
        }
        return ElementMatchers.isAnnotatedWith(ElementMatchers.named("co.elastic.apm.api.CaptureTransaction"));
    }

    @Override
    public final Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("public-api", "annotations", "annotations-capture-transaction");
    }

    public static class AdviceClass {
        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object onMethodEnter(@Advice.Origin Class<?> clazz, @SimpleMethodSignatureOffsetMappingFactory.SimpleMethodSignature String signature, @AnnotationValueOffsetMappingFactory.AnnotationValueExtractor(annotationClassName="co.elastic.apm.api.CaptureTransaction", method="value") String transactionName, @AnnotationValueOffsetMappingFactory.AnnotationValueExtractor(annotationClassName="co.elastic.apm.api.CaptureTransaction", method="type") String type) {
            AbstractSpan<?> active = TracerAwareInstrumentation.tracer.getActive();
            if (active == null) {
                Transaction transaction = TracerAwareInstrumentation.tracer.startRootTransaction(clazz.getClassLoader());
                if (transaction != null) {
                    if (transactionName.isEmpty()) {
                        transaction.withName(signature, 100);
                    } else {
                        transaction.withName(transactionName, 1000);
                    }
                    ((Transaction)transaction.withType(type)).activate();
                    transaction.setFrameworkName("API");
                    return transaction;
                }
            } else {
                logger.debug("Not creating transaction for method {} because there is already a transaction running ({})", (Object)signature, (Object)active);
            }
            return null;
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onMethodExit(@Advice.Enter @Nullable Object transaction, @Advice.Thrown @Nullable Throwable t) {
            if (transaction instanceof Transaction) {
                ((Transaction)((Transaction)((Transaction)((Transaction)transaction).captureException(t)).withOutcome(t != null ? Outcome.FAILURE : Outcome.SUCCESS)).deactivate()).end();
            }
        }
    }
}

