/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.pluginapi;

import co.elastic.apm.agent.impl.context.ServiceTarget;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.pluginapi.ApiInstrumentation;
import co.elastic.apm.agent.pluginapi.HeaderInjectorBridge;
import java.lang.invoke.MethodHandle;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class AbstractSpanInstrumentation
extends ApiInstrumentation {
    private final ElementMatcher<? super MethodDescription> methodMatcher;

    public AbstractSpanInstrumentation(ElementMatcher<? super MethodDescription> methodMatcher) {
        this.methodMatcher = methodMatcher;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("co.elastic.apm.api.AbstractSpanImpl");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return this.methodMatcher;
    }

    public static class SetNonDiscardableInstrumentation
    extends AbstractSpanInstrumentation {
        public SetNonDiscardableInstrumentation() {
            super(ElementMatchers.named("doSetNonDiscardable"));
        }

        public static class AdviceClass {
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static void setNonDiscardable(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object context) {
                if (context instanceof AbstractSpan) {
                    ((AbstractSpan)context).setNonDiscardable();
                }
            }
        }
    }

    public static class SetServiceTargetInstrumentation
    extends AbstractSpanInstrumentation {
        public SetServiceTargetInstrumentation() {
            super(ElementMatchers.named("doSetServiceTarget"));
        }

        public static class AdviceClass {
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static void setServiceTarget(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object context, @Advice.Argument(value=0) @Nullable String type, @Advice.Argument(value=1) @Nullable String name) {
                if (context instanceof Span) {
                    ((Span)context).getContext().getServiceTarget().withUserType(type).withUserName(name);
                }
            }
        }
    }

    public static class SetDestinationServiceInstrumentation
    extends AbstractSpanInstrumentation {
        public SetDestinationServiceInstrumentation() {
            super(ElementMatchers.named("doSetDestinationService"));
        }

        public static class AdviceClass {
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static void setDestinationService(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object context, @Advice.Argument(value=0) @Nullable String resource) {
                if (context instanceof Span) {
                    ServiceTarget serviceTarget = ((Span)context).getContext().getServiceTarget();
                    if (resource == null || resource.isEmpty()) {
                        serviceTarget.withUserType(null).withUserName(null);
                    } else {
                        String currentType = serviceTarget.getType();
                        serviceTarget.withUserType(currentType != null ? currentType : "").withUserName(resource).withNameOnlyDestinationResource();
                    }
                }
            }
        }
    }

    public static class SetDestinationAddressInstrumentation
    extends AbstractSpanInstrumentation {
        public SetDestinationAddressInstrumentation() {
            super(ElementMatchers.named("doSetDestinationAddress"));
        }

        public static class AdviceClass {
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static void setDestinationAddress(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object context, @Advice.Argument(value=0) @Nullable String address, @Advice.Argument(value=1) int port) {
                if (context instanceof Span) {
                    ((Span)context).getContext().getDestination().withUserAddress(address).withUserPort(port);
                }
            }
        }
    }

    public static class InjectTraceHeadersInstrumentation
    extends AbstractSpanInstrumentation {
        public InjectTraceHeadersInstrumentation() {
            super(ElementMatchers.named("doInjectTraceHeaders"));
        }

        public static class AdviceClass {
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static void injectTraceHeaders(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object context, @Advice.Argument(value=0) MethodHandle addHeaderMethodHandle, @Advice.Argument(value=1) @Nullable Object headerInjector) {
                if (headerInjector != null && context instanceof AbstractSpan) {
                    ((AbstractSpan)context).propagateTraceContext(headerInjector, HeaderInjectorBridge.get(addHeaderMethodHandle));
                }
            }
        }
    }

    public static class IsSampledInstrumentation
    extends AbstractSpanInstrumentation {
        public IsSampledInstrumentation() {
            super(ElementMatchers.named("isSampled"));
        }

        public static class AdviceClass {
            @Advice.AssignReturned.ToReturned
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static boolean isSampled(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object context, @Advice.Return boolean returnValue) {
                if (context instanceof AbstractSpan) {
                    return ((AbstractSpan)context).isSampled();
                }
                return returnValue;
            }
        }
    }

    public static class ActivateInstrumentation
    extends AbstractSpanInstrumentation {
        public ActivateInstrumentation() {
            super(ElementMatchers.named("activate"));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void activate(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object context) {
                if (context instanceof AbstractSpan) {
                    ((AbstractSpan)context).activate();
                }
            }
        }
    }

    public static class AddBooleanLabelInstrumentation
    extends AbstractSpanInstrumentation {
        public AddBooleanLabelInstrumentation() {
            super(ElementMatchers.named("doAddBooleanLabel"));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void addLabel(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object context, @Advice.Argument(value=0) String key, @Advice.Argument(value=1) @Nullable Boolean value) {
                if (value != null && context instanceof AbstractSpan) {
                    ((AbstractSpan)context).addLabel(key, value);
                }
            }
        }
    }

    public static class AddNumberLabelInstrumentation
    extends AbstractSpanInstrumentation {
        public AddNumberLabelInstrumentation() {
            super(ElementMatchers.named("doAddNumberLabel"));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void addLabel(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object context, @Advice.Argument(value=0) String key, @Advice.Argument(value=1) @Nullable Number value) {
                if (value != null && context instanceof AbstractSpan) {
                    ((AbstractSpan)context).addLabel(key, value);
                }
            }
        }
    }

    public static class AddStringLabelInstrumentation
    extends AbstractSpanInstrumentation {
        public AddStringLabelInstrumentation() {
            super(ElementMatchers.named("doAddTag").or(ElementMatchers.named("doAddStringLabel")));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void addLabel(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object context, @Advice.Argument(value=0) String key, @Advice.Argument(value=1) @Nullable String value) {
                if (value != null && context instanceof AbstractSpan) {
                    ((AbstractSpan)context).addLabel(key, value);
                }
            }
        }
    }

    public static class GetTraceIdInstrumentation
    extends AbstractSpanInstrumentation {
        public GetTraceIdInstrumentation() {
            super(ElementMatchers.named("getTraceId").and(ElementMatchers.takesArguments(0)));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.AssignReturned.ToReturned
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static String getTraceId(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object context, @Advice.Return @Nullable String returnValue) {
                if (context instanceof AbstractSpan) {
                    return ((AbstractSpan)context).getTraceContext().getTraceId().toString();
                }
                return returnValue;
            }
        }
    }

    public static class GetIdInstrumentation
    extends AbstractSpanInstrumentation {
        public GetIdInstrumentation() {
            super(ElementMatchers.named("getId").and(ElementMatchers.takesArguments(0)));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.AssignReturned.ToReturned
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static String getId(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object context, @Advice.Return @Nullable String returnValue) {
                if (context instanceof AbstractSpan) {
                    return ((AbstractSpan)context).getTraceContext().getId().toString();
                }
                return returnValue;
            }
        }
    }

    public static class LegacyCaptureExceptionInstrumentation
    extends AbstractSpanInstrumentation {
        public LegacyCaptureExceptionInstrumentation() {
            super(ElementMatchers.named("captureException").and(ElementMatchers.takesArguments(Throwable.class)).and(ElementMatchers.returns(Void.class)));
        }

        public static class AdviceClass {
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static void captureException(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object context, @Advice.Argument(value=0) Throwable t) {
                if (context instanceof AbstractSpan) {
                    ((AbstractSpan)context).captureException(t);
                }
            }
        }
    }

    public static class CaptureExceptionInstrumentation
    extends AbstractSpanInstrumentation {
        public CaptureExceptionInstrumentation() {
            super(ElementMatchers.named("captureException").and(ElementMatchers.takesArguments(Throwable.class)).and(ElementMatchers.returns(String.class)));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.AssignReturned.ToReturned
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static String captureException(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object context, @Advice.Argument(value=0) Throwable t, @Advice.Return @Nullable String returnValue) {
                if (context instanceof AbstractSpan) {
                    return ((AbstractSpan)context).captureExceptionAndGetErrorId(t);
                }
                return returnValue;
            }
        }
    }

    public static class EndWithTimestampInstrumentation
    extends AbstractSpanInstrumentation {
        public EndWithTimestampInstrumentation() {
            super(ElementMatchers.named("end").and(ElementMatchers.takesArguments(Long.TYPE)));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void end(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object context, @Advice.Argument(value=0) long epochMicros) {
                if (context instanceof AbstractSpan) {
                    ((AbstractSpan)context).end(epochMicros);
                }
            }
        }
    }

    public static class EndInstrumentation
    extends AbstractSpanInstrumentation {
        public EndInstrumentation() {
            super(ElementMatchers.named("end").and(ElementMatchers.takesArguments(0)));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void end(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object context) {
                if (context instanceof AbstractSpan) {
                    ((AbstractSpan)context).end();
                }
            }
        }
    }

    public static class SetOutcomeInstrumentation
    extends AbstractSpanInstrumentation {
        public SetOutcomeInstrumentation() {
            super(ElementMatchers.named("doSetOutcome").and(ElementMatchers.takesArguments(1).and(ElementMatchers.takesArgument(0, ElementMatchers.named("co.elastic.apm.api.Outcome")))));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void setOutcome(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object context, @Advice.Argument(value=0) @Nullable Enum<?> apiOutcome) {
                if (context instanceof AbstractSpan) {
                    Outcome outcome = Outcome.UNKNOWN;
                    if (apiOutcome != null) {
                        outcome = Outcome.valueOf(apiOutcome.name());
                    }
                    ((AbstractSpan)context).withUserOutcome(outcome);
                }
            }
        }
    }

    public static class SetStartTimestampInstrumentation
    extends AbstractSpanInstrumentation {
        public SetStartTimestampInstrumentation() {
            super(ElementMatchers.named("doSetStartTimestamp").and(ElementMatchers.takesArguments(Long.TYPE)));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void setStartTimestamp(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object context, @Advice.Argument(value=0) long epochMicros) {
                if (context instanceof AbstractSpan) {
                    ((AbstractSpan)context).setStartTimestamp(epochMicros);
                }
            }
        }
    }

    public static class InitializeInstrumentation
    extends AbstractSpanInstrumentation {
        public InitializeInstrumentation() {
            super(ElementMatchers.named("initialize").and(ElementMatchers.takesArgument(0, Object.class)));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void incrementReferences(@Advice.Argument(value=0) Object span) {
                ((AbstractSpan)span).incrementReferences();
            }
        }
    }

    public static class DoCreateExitSpanInstrumentation
    extends AbstractSpanInstrumentation {
        public DoCreateExitSpanInstrumentation() {
            super(ElementMatchers.named("doCreateExitSpan"));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.AssignReturned.ToReturned
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static Object doCreateExitSpan(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object context, @Advice.Return @Nullable Object returnValue) {
                if (context instanceof AbstractSpan) {
                    return ((AbstractSpan)context).createExitSpan();
                }
                return returnValue;
            }
        }
    }

    public static class DoCreateSpanInstrumentation
    extends AbstractSpanInstrumentation {
        public DoCreateSpanInstrumentation() {
            super(ElementMatchers.named("doCreateSpan"));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.AssignReturned.ToReturned
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static Object doCreateSpan(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object context, @Advice.Return @Nullable Object returnValue) {
                if (context instanceof AbstractSpan) {
                    return ((AbstractSpan)context).createSpan();
                }
                return returnValue;
            }
        }
    }

    public static class SetTypesInstrumentation
    extends AbstractSpanInstrumentation {
        public SetTypesInstrumentation() {
            super(ElementMatchers.named("doSetTypes"));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void setType(@Advice.Argument(value=0) Object span, @Advice.Argument(value=1) @Nullable String type, @Advice.Argument(value=2) @Nullable String subtype, @Advice.Argument(value=3) @Nullable String action) {
                if (span instanceof Span) {
                    ((Span)span).setType(type, subtype, action);
                }
            }
        }
    }

    public static class SetTypeInstrumentation
    extends AbstractSpanInstrumentation {
        public SetTypeInstrumentation() {
            super(ElementMatchers.named("doSetType"));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void setType(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object context, @Advice.Argument(value=0) String type) {
                if (context instanceof Transaction) {
                    ((Transaction)context).withType(type);
                } else if (context instanceof Span) {
                    ((Span)context).setType(type, null, null);
                }
            }
        }
    }

    public static class SetNameInstrumentation
    extends AbstractSpanInstrumentation {
        public SetNameInstrumentation() {
            super(ElementMatchers.named("doSetName"));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void setName(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object context, @Advice.Argument(value=0) String name) {
                if (context instanceof AbstractSpan) {
                    ((AbstractSpan)context).withName(name, 1000);
                }
            }
        }
    }
}

