/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.opentracingimpl;

import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.opentracingimpl.OpenTracingBridgeInstrumentation;
import co.elastic.apm.agent.opentracingimpl.OpenTracingTextMapBridge;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class SpanContextInstrumentation
extends OpenTracingBridgeInstrumentation {
    public static final Logger logger = LoggerFactory.getLogger(SpanContextInstrumentation.class);
    private final ElementMatcher<? super MethodDescription> methodMatcher;

    public SpanContextInstrumentation(ElementMatcher<? super MethodDescription> methodMatcher) {
        this.methodMatcher = methodMatcher;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("co.elastic.apm.opentracing.TraceContextSpanContext");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return this.methodMatcher;
    }

    public static class ToSpanIdInstrumentation
    extends SpanContextInstrumentation {
        public ToSpanIdInstrumentation() {
            super(ElementMatchers.named("toSpanId"));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.AssignReturned.ToReturned
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static String toTraceId(@Advice.FieldValue(value="traceContext", typing=Assigner.Typing.DYNAMIC) @Nullable Object context) {
                if (!(context instanceof AbstractSpan)) {
                    return null;
                }
                AbstractSpan traceContext = (AbstractSpan)context;
                return traceContext.getTraceContext().getId().toString();
            }
        }
    }

    public static class ToTraceIdInstrumentation
    extends SpanContextInstrumentation {
        public ToTraceIdInstrumentation() {
            super(ElementMatchers.named("toTraceId"));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.AssignReturned.ToReturned
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static String toTraceId(@Advice.FieldValue(value="traceContext", typing=Assigner.Typing.DYNAMIC) @Nullable Object context) {
                if (!(context instanceof AbstractSpan)) {
                    return null;
                }
                AbstractSpan traceContext = (AbstractSpan)context;
                return traceContext.getTraceContext().getTraceId().toString();
            }
        }
    }

    public static class BaggageItemsInstrumentation
    extends SpanContextInstrumentation {
        public BaggageItemsInstrumentation() {
            super(ElementMatchers.named("baggageItems"));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.AssignReturned.ToReturned
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static Iterable<Map.Entry<String, String>> baggageItems(@Advice.FieldValue(value="traceContext", typing=Assigner.Typing.DYNAMIC) @Nullable Object context) {
                if (context instanceof AbstractSpan) {
                    return AdviceClass.doGetBaggage((AbstractSpan)context);
                }
                logger.info("The traceContext is null");
                return null;
            }

            public static Iterable<Map.Entry<String, String>> doGetBaggage(AbstractSpan<?> traceContext) {
                HashMap baggage = new HashMap();
                traceContext.propagateTraceContext(baggage, OpenTracingTextMapBridge.instance());
                return baggage.entrySet();
            }
        }
    }
}

