/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.opentelemetry.sdk;

import co.elastic.apm.agent.impl.context.Url;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.OTelSpanKind;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.opentelemetry.sdk.OTelSpanContext;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.util.LoggerUtils;
import co.elastic.apm.agent.util.VersionUtils;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.StatusCode;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OTelSpan
implements Span {
    static final String ILLEGAL_ATTRIBUTE_VALUE_TYPE_MESSAGE_FORMAT = "`%s` attribute's value type must be boolean, `%s` is illegal";
    private static final Logger eventLogger = LoggerUtils.logOnce(LoggerFactory.getLogger(OTelSpan.class));
    private final AbstractSpan<?> span;

    public OTelSpan(AbstractSpan<?> span) {
        this.span = span;
        span.incrementReferences();
    }

    public <T> Span setAttribute(AttributeKey<T> key, @Nonnull T value) {
        boolean behavioralAttribute = false;
        if ("co.elastic.discardable".equals(key.getKey())) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException(String.format(ILLEGAL_ATTRIBUTE_VALUE_TYPE_MESSAGE_FORMAT, "co.elastic.discardable", value));
            }
            if (!((Boolean)value).booleanValue()) {
                this.span.setNonDiscardable();
            }
            behavioralAttribute = true;
        }
        if (!behavioralAttribute) {
            this.span.getOtelAttributes().put(key.getKey(), value);
        }
        return this;
    }

    public Span addEvent(String name, Attributes attributes) {
        eventLogger.warn("The addEvent API is not supported at the moment");
        return this;
    }

    public Span addEvent(String name, Attributes attributes, long timestamp, TimeUnit unit) {
        eventLogger.warn("The addEvent API is not supported at the moment");
        return this;
    }

    public Span setStatus(StatusCode statusCode, String description) {
        switch (statusCode) {
            case ERROR: {
                this.span.withUserOutcome(Outcome.FAILURE);
                break;
            }
            case OK: {
                this.span.withUserOutcome(Outcome.SUCCESS);
                break;
            }
            case UNSET: {
                this.span.withUserOutcome(Outcome.UNKNOWN);
            }
        }
        return this;
    }

    public Span recordException(Throwable exception, Attributes additionalAttributes) {
        this.span.captureException(exception);
        return this;
    }

    public Span updateName(String name) {
        this.span.withName(name);
        return this;
    }

    public void end() {
        if (this.span instanceof Transaction) {
            this.onTransactionEnd((Transaction)this.span);
        } else if (this.span instanceof co.elastic.apm.agent.impl.transaction.Span) {
            this.onSpanEnd((co.elastic.apm.agent.impl.transaction.Span)this.span);
        }
        this.span.end();
    }

    private void onTransactionEnd(Transaction t) {
        Map<String, Object> attributes = this.span.getOtelAttributes();
        boolean isRpc = attributes.containsKey("rpc.system");
        boolean isHttp = attributes.containsKey("http.url") || attributes.containsKey("http.scheme");
        boolean isMessaging = attributes.containsKey("messaging.system");
        String type = "unknown";
        if (this.span.getOtelKind() == OTelSpanKind.SERVER && (isRpc || isHttp)) {
            type = "request";
        } else if (this.span.getOtelKind() == OTelSpanKind.CONSUMER && isMessaging) {
            type = "messaging";
        }
        t.withType(type);
        t.setFrameworkName("OpenTelemetry");
        t.setFrameworkVersion(VersionUtils.getVersion(OpenTelemetry.class, "io.opentelemetry", "opentelemetry-api"));
    }

    private void onSpanEnd(co.elastic.apm.agent.impl.transaction.Span s) {
        Map<String, Object> attributes = s.getOtelAttributes();
        String type = null;
        String subType = null;
        String netPeerIp = (String)attributes.get("net.peer.ip");
        String netPeerName = (String)attributes.get("net.peer.name");
        Long netPortLong = (Long)attributes.get("net.peer.port");
        int netPort = -1;
        if (null != netPortLong && netPortLong > 0L) {
            netPort = netPortLong.intValue();
        }
        String netPeer = netPeerName != null ? netPeerName : netPeerIp;
        String httpUrl = (String)attributes.get("http.url");
        String httpScheme = (String)attributes.get("http.scheme");
        String dbSystem = (String)attributes.get("db.system");
        String messagingSystem = (String)attributes.get("messaging.system");
        String rpcSystem = (String)attributes.get("rpc.system");
        if (null != dbSystem) {
            type = "db";
            subType = dbSystem;
            String dbName = (String)attributes.get("db.name");
            s.getContext().getDb().withType(subType).withInstance(dbName);
            s.getContext().getServiceTarget().withType(subType).withName(dbName);
        } else if (messagingSystem != null) {
            type = "messaging";
            subType = messagingSystem;
            String messagingDestination = (String)attributes.get("messaging.destination");
            URI messagingUri = OTelSpan.parseURI((String)attributes.get("messaging.url"));
            if (netPeer == null && messagingUri != null) {
                netPeer = messagingUri.getHost();
                netPort = messagingUri.getPort();
            }
            s.getContext().getServiceTarget().withType(subType).withName(messagingDestination);
        } else if (rpcSystem != null) {
            type = "external";
            subType = rpcSystem;
            String service = (String)attributes.get("rpc.service");
            s.getContext().getServiceTarget().withType(subType).withName(service).withHostPortName(netPeer, netPort).withNameOnlyDestinationResource();
        } else if (httpUrl != null || httpScheme != null) {
            URI httpUri;
            type = "external";
            subType = "http";
            String httpHost = (String)attributes.get("http.host");
            if (null == httpHost) {
                httpHost = netPeer;
            }
            if (httpHost == null && httpUrl != null && (httpUri = OTelSpan.parseURI(httpUrl)) != null) {
                httpHost = httpUri.getHost();
                netPort = httpUri.getPort();
                httpScheme = httpUri.getScheme();
            }
            netPort = Url.normalizePort(netPort, httpScheme);
            s.getContext().getServiceTarget().withType(subType).withHostPortName(httpHost, netPort).withNameOnlyDestinationResource();
        }
        if (type == null) {
            type = "unknown";
            if (s.getOtelKind() == OTelSpanKind.INTERNAL) {
                type = "app";
                subType = "internal";
            }
        }
        if (netPeer != null && netPort > 0) {
            s.getContext().getDestination().withAddress(netPeer).withPort(netPort);
        }
        ((co.elastic.apm.agent.impl.transaction.Span)s.withType(type)).withSubtype(subType);
    }

    @Nullable
    private static URI parseURI(@Nullable String s) {
        if (null == s) {
            return null;
        }
        try {
            return new URI(s);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public void end(long timestamp, TimeUnit unit) {
        if (this.span instanceof Transaction) {
            this.onTransactionEnd((Transaction)this.span);
        } else if (this.span instanceof co.elastic.apm.agent.impl.transaction.Span) {
            this.onSpanEnd((co.elastic.apm.agent.impl.transaction.Span)this.span);
        }
        this.span.end(unit.toMicros(timestamp));
    }

    public SpanContext getSpanContext() {
        return new OTelSpanContext(this.span.getTraceContext());
    }

    public boolean isRecording() {
        return this.span.isSampled();
    }

    public AbstractSpan<?> getInternalSpan() {
        return this.span;
    }

    public String toString() {
        return "OtelSpan[" + this.span + "]";
    }
}

