/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.opentelemetry.sdk;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.ElasticContext;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.opentelemetry.sdk.OTelSpan;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import java.util.Objects;
import javax.annotation.Nullable;

public class OTelBridgeContext
implements ElasticContext<OTelBridgeContext>,
Context,
Scope {
    @Nullable
    private static volatile Context originalRootContext;
    @Nullable
    private static volatile OTelBridgeContext root;
    private final Context otelContext;
    private final ElasticApmTracer tracer;

    private OTelBridgeContext(ElasticApmTracer tracer, Context otelContext) {
        this.tracer = tracer;
        this.otelContext = otelContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OTelBridgeContext bridgeRootContext(ElasticApmTracer tracer, Context originalRoot) {
        if (root != null) {
            return root;
        }
        Class<OTelBridgeContext> clazz = OTelBridgeContext.class;
        synchronized (OTelBridgeContext.class) {
            if (root == null) {
                originalRootContext = originalRoot;
                root = new OTelBridgeContext(tracer, originalRoot);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return root;
        }
    }

    public static OTelBridgeContext wrapElasticActiveSpan(ElasticApmTracer tracer, AbstractSpan<?> span) {
        OTelSpan otelSpan = new OTelSpan(span);
        Objects.requireNonNull(originalRootContext, "OTel original context must be set through bridgeRootContext first");
        return new OTelBridgeContext(tracer, originalRootContext.with((ImplicitContextKeyed)otelSpan));
    }

    @Override
    public OTelBridgeContext activate() {
        this.tracer.activate(this);
        return this;
    }

    @Override
    public co.elastic.apm.agent.impl.Scope activateInScope() {
        return this.tracer.activateInScope(this);
    }

    public OTelBridgeContext withActiveSpan(AbstractSpan<?> span) {
        return new OTelBridgeContext(this.tracer, this.otelContext.with((ImplicitContextKeyed)new OTelSpan(span)));
    }

    @Override
    public OTelBridgeContext deactivate() {
        this.tracer.deactivate(this);
        return this;
    }

    @Override
    @Nullable
    public AbstractSpan<?> getSpan() {
        Span span = Span.fromContext((Context)this.otelContext);
        if (span instanceof OTelSpan) {
            return ((OTelSpan)span).getInternalSpan();
        }
        return null;
    }

    @Override
    @Nullable
    public Transaction getTransaction() {
        AbstractSpan<?> span = this.getSpan();
        return span != null ? span.getTransaction() : null;
    }

    @Nullable
    public <V> V get(ContextKey<V> key) {
        return (V)this.otelContext.get(key);
    }

    public <V> Context with(ContextKey<V> key, V value) {
        return new OTelBridgeContext(this.tracer, this.otelContext.with(key, value));
    }

    public void close() {
        this.deactivate();
    }

    public String toString() {
        return "OTelBridgeContext[" + this.otelContext + "]";
    }
}

