/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.okhttp;

import co.elastic.apm.agent.sdk.state.GlobalState;
import co.elastic.apm.agent.sdk.weakconcurrent.DetachedThreadLocal;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakConcurrent;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakMap;
import javax.annotation.Nullable;

@GlobalState
public class OkHttpClientHelper {
    public static final DetachedThreadLocal<StringBuilder> destinationHostName = WeakConcurrent.threadLocalBuilder().withDefaultValueSupplier(new WeakMap.DefaultValueSupplier<Thread, StringBuilder>(){

        @Override
        public StringBuilder getDefaultValue(Thread t) {
            return new StringBuilder();
        }
    }).build();

    @Nullable
    public static CharSequence computeHostName(@Nullable String originalHostName) {
        CharSequence hostName = originalHostName;
        if (originalHostName != null && originalHostName.contains(":") && !originalHostName.startsWith("[")) {
            StringBuilder sb = destinationHostName.get();
            sb.setLength(0);
            sb.append("[").append(originalHostName).append("]");
            hostName = sb;
        }
        return hostName;
    }
}

