/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.okhttp;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.httpclient.HttpClientHelper;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.okhttp.AbstractOkHttp3ClientInstrumentation;
import co.elastic.apm.agent.okhttp.OkHttp3RequestHeaderGetter;
import co.elastic.apm.agent.okhttp.OkHttp3RequestHeaderSetter;
import co.elastic.apm.agent.okhttp.OkHttpClientHelper;
import co.elastic.apm.agent.okhttp.WrapperCreator;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import java.io.IOException;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;

public class OkHttp3ClientAsyncInstrumentation
extends AbstractOkHttp3ClientInstrumentation {
    public static final Logger logger = LoggerFactory.getLogger(OkHttp3ClientAsyncInstrumentation.class);

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.okhttp.OkHttp3ClientAsyncInstrumentation$OkHttpClient3ExecuteAdvice";
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.nameStartsWith("okhttp3.").and(ElementMatchers.nameEndsWith(".RealCall"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("enqueue").and(ElementMatchers.takesArguments(1)).and(ElementMatchers.takesArgument(0, ElementMatchers.named("okhttp3.Callback"))).and(ElementMatchers.returns(Void.TYPE));
    }

    public static class CallbackWrapperCreator
    implements WrapperCreator<Callback> {
        public static final CallbackWrapperCreator INSTANCE = new CallbackWrapperCreator();

        @Override
        public Callback wrap(Callback delegate, Span span) {
            return new CallbackWrapper(span, delegate);
        }

        private static class CallbackWrapper
        implements Callback {
            private final Span span;
            private final Callback delegate;

            CallbackWrapper(Span span, Callback delegate) {
                this.span = span;
                this.delegate = delegate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFailure(Call call, IOException e) {
                try {
                    ((Span)((Span)this.span.captureException(e)).withOutcome(Outcome.FAILURE)).end();
                }
                catch (Throwable t) {
                    logger.error(t.getMessage(), t);
                }
                finally {
                    this.delegate.onFailure(call, e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) throws IOException {
                try {
                    this.span.getContext().getHttp().withStatusCode(response.code());
                    this.span.end();
                }
                catch (Throwable t) {
                    logger.error(t.getMessage(), t);
                }
                finally {
                    this.delegate.onResponse(call, response);
                }
            }
        }
    }

    public static class OkHttpClient3ExecuteAdvice {
        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        @Advice.AssignReturned.ToFields(value={@Advice.AssignReturned.ToFields.ToField(index=0, value="originalRequest", typing=Assigner.Typing.DYNAMIC)})
        @Advice.AssignReturned.ToArguments(value={@Advice.AssignReturned.ToArguments.ToArgument(index=1, value=0, typing=Assigner.Typing.DYNAMIC)})
        public static Object[] onBeforeEnqueue(@Advice.Origin Class<? extends Call> clazz, @Advice.FieldValue(value="originalRequest") @Nullable Request originalRequest, @Advice.Argument(value=0) @Nullable Callback originalCallback) {
            AbstractSpan<?> parent = TracerAwareInstrumentation.tracer.getActive();
            if (parent == null) {
                return null;
            }
            if (originalRequest == null || originalCallback == null) {
                return null;
            }
            Request request = originalRequest;
            Callback callback = originalCallback;
            HttpUrl url = request.url();
            Span span = HttpClientHelper.startHttpClientSpan(parent, request.method(), url.toString(), url.scheme(), OkHttpClientHelper.computeHostName(url.host()), url.port());
            if (span != null) {
                span.activate();
            }
            if (!TraceContext.containsTraceContextTextHeaders(request, OkHttp3RequestHeaderGetter.INSTANCE)) {
                Request.Builder builder = originalRequest.newBuilder();
                if (span != null) {
                    span.propagateTraceContext(builder, OkHttp3RequestHeaderSetter.INSTANCE);
                    request = builder.build();
                    callback = CallbackWrapperCreator.INSTANCE.wrap(callback, span);
                } else {
                    parent.propagateTraceContext(builder, OkHttp3RequestHeaderSetter.INSTANCE);
                    request = builder.build();
                }
            }
            return new Object[]{request, callback, span};
        }

        @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
        public static void onAfterEnqueue(@Advice.Enter @Nullable Object[] enter) {
            Span span;
            Span span2 = span = enter != null ? (Span)enter[2] : null;
            if (span != null) {
                span.deactivate();
            }
        }
    }
}

