/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.mongoclient;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.mongoclient.MongoClientInstrumentation;
import com.mongodb.MongoNamespace;
import com.mongodb.ServerAddress;
import com.mongodb.connection.Connection;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ConnectionInstrumentation
extends MongoClientInstrumentation {
    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.nameStartsWith("insert").or(ElementMatchers.nameStartsWith("update")).or(ElementMatchers.nameStartsWith("delete")).or(ElementMatchers.nameStartsWith("query")).or(ElementMatchers.nameStartsWith("getMore")).and(ElementMatchers.isPublic()).and(ElementMatchers.takesArgument(0, ElementMatchers.named("com.mongodb.MongoNamespace")));
    }

    public static class AdviceClass {
        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object onEnter(@Advice.This Connection thiz, @Advice.Argument(value=0) MongoNamespace namespace, @Advice.Origin(value="#m") String methodName) {
            AbstractSpan span = null;
            AbstractSpan<?> activeSpan = TracerAwareInstrumentation.tracer.getActive();
            if (activeSpan != null && !activeSpan.isExit()) {
                span = activeSpan.createExitSpan();
            }
            if (span == null) {
                return null;
            }
            ((Span)span.withType("db")).withSubtype("mongodb").getContext().getDb().withType("mongodb");
            ((Span)span).getContext().getServiceTarget().withType("mongodb").withName(namespace.getDatabaseName());
            ((Span)span).getContext().getDb().withInstance(namespace.getDatabaseName());
            ServerAddress serverAddress = thiz.getDescription().getServerAddress();
            ((Span)span).getContext().getDestination().withAddress(serverAddress.getHost()).withPort(serverAddress.getPort());
            String command = methodName;
            if (methodName.equals("query")) {
                command = "find";
            }
            ((Span)span).withAction(command);
            StringBuilder spanName = span.getAndOverrideName(0);
            if (spanName != null) {
                int indexOfCommand = command.indexOf("Command");
                spanName.append(namespace.getDatabaseName()).append(".").append(namespace.getCollectionName()).append(".").append(command, 0, indexOfCommand > 0 ? indexOfCommand : command.length());
            }
            span.activate();
            return span;
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onExit(@Nullable @Advice.Enter Object spanObj, @Advice.Thrown Throwable thrown) {
            if (spanObj instanceof Span) {
                Span span = (Span)spanObj;
                ((Span)span.deactivate()).captureException(thrown);
                span.end();
            }
        }
    }
}

