/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.micrometer;

import co.elastic.apm.agent.configuration.MetricsConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.Tracer;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.micrometer.MicrometerMeterRegistrySerializer;
import co.elastic.apm.agent.report.Reporter;
import co.elastic.apm.agent.report.ReporterConfiguration;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakConcurrent;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakSet;
import com.dslplatform.json.JsonWriter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.io.Closeable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class MicrometerMetricsReporter
implements Runnable,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(MicrometerMetricsReporter.class);
    private final WeakSet<MeterRegistry> meterRegistries = WeakConcurrent.buildSet();
    private final MicrometerMeterRegistrySerializer serializer;
    private final Reporter reporter;
    private final ElasticApmTracer tracer;
    private boolean scheduledReporting = false;

    public MicrometerMetricsReporter(ElasticApmTracer tracer) {
        this.tracer = tracer;
        this.reporter = tracer.getReporter();
        tracer.addShutdownHook(this);
        this.serializer = new MicrometerMeterRegistrySerializer(tracer.getConfig(MetricsConfiguration.class));
    }

    public void registerMeterRegistry(MeterRegistry meterRegistry) {
        if (meterRegistry instanceof CompositeMeterRegistry) {
            return;
        }
        boolean added = this.meterRegistries.add(meterRegistry);
        if (added) {
            logger.info("Registering Micrometer MeterRegistry: {}", (Object)meterRegistry);
            this.scheduleReporting();
        }
    }

    private synchronized void scheduleReporting() {
        if (this.scheduledReporting) {
            return;
        }
        this.scheduledReporting = true;
        long metricsIntervalMs = this.tracer.getConfig(ReporterConfiguration.class).getMetricsIntervalMs();
        if (metricsIntervalMs > 0L) {
            this.tracer.getSharedSingleThreadedPool().scheduleAtFixedRate(this, metricsIntervalMs, metricsIntervalMs, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void run() {
        if (this.tracer.getState() != Tracer.TracerState.RUNNING) {
            return;
        }
        long timestamp = System.currentTimeMillis() * 1000L;
        MeterMapConsumer meterConsumer = new MeterMapConsumer(this.tracer.getConfig(ReporterConfiguration.class).getDisableMetrics());
        for (MeterRegistry registry : this.meterRegistries) {
            registry.forEachMeter((Consumer)meterConsumer);
        }
        logger.debug("Reporting {} meters", (Object)meterConsumer.meters.size());
        for (JsonWriter serializedMetricSet : this.serializer.serialize(meterConsumer.meters, timestamp)) {
            this.reporter.report(serializedMetricSet);
        }
    }

    @Override
    public void close() {
        this.tracer.getSharedSingleThreadedPool().submit(this);
    }

    WeakSet<MeterRegistry> getMeterRegistries() {
        return this.meterRegistries;
    }

    Iterable<Meter> getFailedMeters() {
        return this.serializer.getFailedMeters();
    }

    private static class MeterMapConsumer
    implements Consumer<Meter> {
        private final List<WildcardMatcher> disabledMetrics;
        final Map<Meter.Id, Meter> meters = new HashMap<Meter.Id, Meter>();

        public MeterMapConsumer(List<WildcardMatcher> disabledMetrics) {
            this.disabledMetrics = disabledMetrics;
        }

        @Override
        public void accept(Meter meter) {
            Meter.Id meterId = meter.getId();
            if (WildcardMatcher.isNoneMatch(this.disabledMetrics, meterId.getName())) {
                this.meters.put(meterId, meter);
            }
        }
    }
}

