/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.micrometer;

import co.elastic.apm.agent.configuration.MetricsConfiguration;
import co.elastic.apm.agent.report.serialize.DslJsonSerializer;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakConcurrent;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakSet;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.NumberConverter;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class MicrometerMeterRegistrySerializer {
    private static final byte NEW_LINE = 10;
    private static final int BUFFER_SIZE_LIMIT = 2048;
    private static final Logger logger = LoggerFactory.getLogger(MicrometerMeterRegistrySerializer.class);
    private final DslJson<Object> dslJson = new DslJson(new DslJson.Settings());
    private final StringBuilder replaceBuilder = new StringBuilder();
    private final MetricsConfiguration config;
    private final WeakSet<Meter> internallyDisabledMeters = WeakConcurrent.buildSet();
    private int maxSerializedSize = 512;

    public MicrometerMeterRegistrySerializer(MetricsConfiguration config) {
        this.config = config;
    }

    Iterable<Meter> getFailedMeters() {
        return this.internallyDisabledMeters;
    }

    public List<JsonWriter> serialize(Map<Meter.Id, Meter> metersById, long epochMicros) {
        ArrayList<JsonWriter> serializedMeters = new ArrayList<JsonWriter>();
        HashMap<List, ArrayList<Meter>> metersGroupedByTags = new HashMap<List, ArrayList<Meter>>();
        for (Map.Entry<Meter.Id, Meter> entry : metersById.entrySet()) {
            List tags = entry.getKey().getTags();
            ArrayList<Meter> meters = (ArrayList<Meter>)metersGroupedByTags.get(tags);
            if (meters == null) {
                meters = new ArrayList<Meter>(1);
                metersGroupedByTags.put(tags, meters);
            }
            meters.add(entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : metersGroupedByTags.entrySet()) {
            JsonWriter jw = this.dslJson.newWriter(this.maxSerializedSize);
            if (!this.serializeMetricSet((List)entry.getKey(), (List)entry.getValue(), epochMicros, this.replaceBuilder, jw)) continue;
            serializedMeters.add(jw);
            this.maxSerializedSize = Math.max(Math.min(jw.size(), 2048), this.maxSerializedSize);
        }
        return serializedMeters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean serializeMetricSet(List<Tag> tags, List<Meter> meters, long epochMicros, StringBuilder replaceBuilder, JsonWriter jw) {
        boolean hasSamples = false;
        boolean dedotMetricName = this.config.isDedotCustomMetrics();
        jw.writeByte((byte)123);
        DslJsonSerializer.writeFieldName("metricset", jw);
        jw.writeByte((byte)123);
        DslJsonSerializer.writeFieldName("timestamp", jw);
        NumberConverter.serialize(epochMicros, jw);
        jw.writeByte((byte)44);
        MicrometerMeterRegistrySerializer.serializeTags(tags, replaceBuilder, jw);
        DslJsonSerializer.writeFieldName("samples", jw);
        jw.writeByte((byte)123);
        ClassLoader originalContextCL = Thread.currentThread().getContextClassLoader();
        try {
            int size = meters.size();
            for (int i = 0; i < size; ++i) {
                Meter meter = meters.get(i);
                if (this.internallyDisabledMeters.contains(meter)) continue;
                try {
                    Counter counter;
                    Timer timer;
                    Thread.currentThread().setContextClassLoader(meter.getClass().getClassLoader());
                    if (meter instanceof Timer) {
                        timer = (Timer)meter;
                        hasSamples = MicrometerMeterRegistrySerializer.serializeTimer(jw, timer.getId(), timer.count(), timer.totalTime(TimeUnit.MICROSECONDS), hasSamples, replaceBuilder, dedotMetricName);
                        continue;
                    }
                    if (meter instanceof FunctionTimer) {
                        timer = (FunctionTimer)meter;
                        hasSamples = MicrometerMeterRegistrySerializer.serializeTimer(jw, timer.getId(), (long)timer.count(), timer.totalTime(TimeUnit.MICROSECONDS), hasSamples, replaceBuilder, dedotMetricName);
                        continue;
                    }
                    if (meter instanceof LongTaskTimer) {
                        timer = (LongTaskTimer)meter;
                        hasSamples = MicrometerMeterRegistrySerializer.serializeTimer(jw, timer.getId(), timer.activeTasks(), timer.duration(TimeUnit.MICROSECONDS), hasSamples, replaceBuilder, dedotMetricName);
                        continue;
                    }
                    if (meter instanceof DistributionSummary) {
                        timer = (DistributionSummary)meter;
                        hasSamples = MicrometerMeterRegistrySerializer.serializeDistributionSummary(jw, timer.getId(), timer.count(), timer.totalAmount(), hasSamples, replaceBuilder, dedotMetricName);
                        continue;
                    }
                    if (meter instanceof Gauge) {
                        Gauge gauge = (Gauge)meter;
                        hasSamples = MicrometerMeterRegistrySerializer.serializeValue(gauge.getId(), gauge.value(), hasSamples, jw, replaceBuilder, dedotMetricName);
                        continue;
                    }
                    if (meter instanceof Counter) {
                        counter = (Counter)meter;
                        hasSamples = MicrometerMeterRegistrySerializer.serializeValue(counter.getId(), counter.count(), hasSamples, jw, replaceBuilder, dedotMetricName);
                        continue;
                    }
                    if (!(meter instanceof FunctionCounter)) continue;
                    counter = (FunctionCounter)meter;
                    hasSamples = MicrometerMeterRegistrySerializer.serializeValue(counter.getId(), counter.count(), hasSamples, jw, replaceBuilder, dedotMetricName);
                    continue;
                }
                catch (Throwable throwable) {
                    String meterName = meter.getId().getName();
                    logger.warn("Failed to serialize Micrometer meter \"{}\" with tags {}. This meter will be excluded from serialization going forward.", (Object)meterName, (Object)tags);
                    logger.debug("Detailed info about failure to register Micrometer meter \"" + meterName + "\": ", throwable);
                    this.internallyDisabledMeters.add(meter);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalContextCL);
        }
        jw.writeByte((byte)125);
        jw.writeByte((byte)125);
        jw.writeByte((byte)125);
        jw.writeByte((byte)10);
        return hasSamples;
    }

    private static void serializeTags(List<Tag> tags, StringBuilder replaceBuilder, JsonWriter jw) {
        if (tags.isEmpty()) {
            return;
        }
        DslJsonSerializer.writeFieldName("tags", jw);
        jw.writeByte((byte)123);
        int tagsSize = tags.size();
        for (int i = 0; i < tagsSize; ++i) {
            Tag tag = tags.get(i);
            if (i > 0) {
                jw.writeByte((byte)44);
            }
            DslJsonSerializer.writeStringValue(DslJsonSerializer.sanitizePropertyName(tag.getKey(), replaceBuilder), replaceBuilder, jw);
            jw.writeByte((byte)58);
            DslJsonSerializer.writeStringValue(tag.getValue(), replaceBuilder, jw);
        }
        jw.writeByte((byte)125);
        jw.writeByte((byte)44);
    }

    private static boolean serializeTimer(JsonWriter jw, Meter.Id id, long count, double totalTime, boolean hasValue, StringBuilder replaceBuilder, boolean dedotMetricName) {
        if (MicrometerMeterRegistrySerializer.isValidValue(totalTime)) {
            if (hasValue) {
                jw.writeByte((byte)44);
            }
            MicrometerMeterRegistrySerializer.serializeValue(id, ".count", count, jw, replaceBuilder, dedotMetricName);
            jw.writeByte((byte)44);
            MicrometerMeterRegistrySerializer.serializeValue(id, ".sum.us", totalTime, jw, replaceBuilder, dedotMetricName);
            return true;
        }
        return hasValue;
    }

    private static boolean serializeDistributionSummary(JsonWriter jw, Meter.Id id, long count, double totalAmount, boolean hasValue, StringBuilder replaceBuilder, boolean dedotMetricName) {
        if (MicrometerMeterRegistrySerializer.isValidValue(totalAmount)) {
            if (hasValue) {
                jw.writeByte((byte)44);
            }
            MicrometerMeterRegistrySerializer.serializeValue(id, ".count", count, jw, replaceBuilder, dedotMetricName);
            jw.writeByte((byte)44);
            MicrometerMeterRegistrySerializer.serializeValue(id, ".sum", totalAmount, jw, replaceBuilder, dedotMetricName);
            return true;
        }
        return hasValue;
    }

    private static void serializeValue(Meter.Id id, String suffix, long value, JsonWriter jw, StringBuilder replaceBuilder, boolean dedotMetricName) {
        MicrometerMeterRegistrySerializer.serializeValueStart(id.getName(), suffix, jw, replaceBuilder, dedotMetricName);
        NumberConverter.serialize(value, jw);
        jw.writeByte((byte)125);
    }

    private static boolean serializeValue(Meter.Id id, double value, boolean hasValue, JsonWriter jw, StringBuilder replaceBuilder, boolean dedotMetricName) {
        if (MicrometerMeterRegistrySerializer.isValidValue(value)) {
            if (hasValue) {
                jw.writeByte((byte)44);
            }
            MicrometerMeterRegistrySerializer.serializeValue(id, "", value, jw, replaceBuilder, dedotMetricName);
            return true;
        }
        return hasValue;
    }

    private static void serializeValue(Meter.Id id, String suffix, double value, JsonWriter jw, StringBuilder replaceBuilder, boolean dedotMetricName) {
        MicrometerMeterRegistrySerializer.serializeValueStart(id.getName(), suffix, jw, replaceBuilder, dedotMetricName);
        NumberConverter.serialize(value, jw);
        jw.writeByte((byte)125);
    }

    private static void serializeValueStart(String key, String suffix, JsonWriter jw, StringBuilder replaceBuilder, boolean dedotMetricName) {
        replaceBuilder.setLength(0);
        if (dedotMetricName) {
            DslJsonSerializer.sanitizePropertyName(key, replaceBuilder);
        } else {
            replaceBuilder.append(key);
        }
        if (suffix != null) {
            if (replaceBuilder.length() == 0) {
                replaceBuilder.append(key);
            }
            replaceBuilder.append(suffix);
        }
        jw.writeString(replaceBuilder);
        jw.writeByte((byte)58);
        jw.writeByte((byte)123);
        jw.writeByte((byte)34);
        jw.writeAscii("value");
        jw.writeByte((byte)34);
        jw.writeByte((byte)58);
    }

    private static boolean isValidValue(double value) {
        return !Double.isNaN(value) && !Double.isInfinite(value);
    }
}

