/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.metrics;

import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.metrics.DoubleSupplier;
import co.elastic.apm.agent.metrics.Labels;
import co.elastic.apm.agent.metrics.MetricSet;
import co.elastic.apm.agent.report.ReporterConfiguration;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.HdrHistogram.WriterReaderPhaser;

public class MetricRegistry {
    private static final Logger logger = LoggerFactory.getLogger(MetricRegistry.class);
    private static final int METRIC_SET_LIMIT = 1000;
    private final WriterReaderPhaser phaser = new WriterReaderPhaser();
    private final ReporterConfiguration config;
    private volatile ConcurrentMap<Labels.Immutable, MetricSet> activeMetricSets = new ConcurrentHashMap<Labels.Immutable, MetricSet>();
    private ConcurrentMap<Labels.Immutable, MetricSet> inactiveMetricSets = new ConcurrentHashMap<Labels.Immutable, MetricSet>();
    private final ConcurrentMap<Labels.Immutable, MetricSet> metricSets1 = this.activeMetricSets;
    private final ConcurrentMap<Labels.Immutable, MetricSet> metricSets2 = this.inactiveMetricSets;

    public MetricRegistry(ReporterConfiguration config) {
        this.config = config;
    }

    public void addUnlessNan(String name, Labels labels, DoubleSupplier metric) {
        if (this.isDisabled(name)) {
            return;
        }
        if (!Double.isNaN(metric.get())) {
            this.add(name, labels, metric);
        }
    }

    public void addUnlessNegative(String name, Labels labels, DoubleSupplier metric) {
        if (this.isDisabled(name)) {
            return;
        }
        if (metric.get() >= 0.0) {
            this.add(name, labels, metric);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String name, Labels labels, DoubleSupplier metric) {
        if (this.isDisabled(name)) {
            return;
        }
        long criticalValueAtEnter = this.phaser.writerCriticalSectionEnter();
        try {
            MetricSet metricSet = this.getOrCreateMetricSet(labels);
            if (metricSet != null) {
                metricSet.addGauge(name, metric);
            }
        }
        finally {
            this.phaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    private boolean isDisabled(String name) {
        return WildcardMatcher.anyMatch(this.config.getDisableMetrics(), name) != null;
    }

    public double getGaugeValue(String name, Labels labels) {
        DoubleSupplier gauge;
        MetricSet metricSet = (MetricSet)this.activeMetricSets.get(labels);
        if (metricSet != null && (gauge = metricSet.getGauge(name)) != null) {
            return gauge.get();
        }
        return Double.NaN;
    }

    @Nullable
    public DoubleSupplier getGauge(String name, Labels labels) {
        DoubleSupplier gauge;
        MetricSet metricSet = (MetricSet)this.activeMetricSets.get(labels);
        if (metricSet != null && (gauge = metricSet.getGauge(name)) != null) {
            return gauge;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flipPhaseAndReport(@Nullable MetricsReporter metricsReporter) {
        try {
            this.phaser.readerLock();
            ConcurrentMap<Labels.Immutable, MetricSet> temp = this.inactiveMetricSets;
            this.inactiveMetricSets = this.activeMetricSets;
            this.activeMetricSets = temp;
            this.phaser.flipPhase();
            if (metricsReporter != null) {
                metricsReporter.report(this.inactiveMetricSets);
            }
            for (MetricSet metricSet : this.inactiveMetricSets.values()) {
                metricSet.resetState();
            }
        }
        finally {
            this.phaser.readerUnlock();
        }
    }

    public void updateTimer(String timerName, Labels labels, long durationUs) {
        this.updateTimer(timerName, labels, durationUs, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTimer(String timerName, Labels labels, long durationUs, long count) {
        long criticalValueAtEnter = this.phaser.writerCriticalSectionEnter();
        try {
            MetricSet metricSet = this.getOrCreateMetricSet(labels);
            if (metricSet != null) {
                metricSet.timer(timerName).update(durationUs, count);
            }
        }
        finally {
            this.phaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    @Nullable
    private MetricSet getOrCreateMetricSet(Labels labels) {
        MetricSet metricSet = (MetricSet)this.activeMetricSets.get(labels);
        if (metricSet != null) {
            return metricSet;
        }
        if (this.activeMetricSets.size() < 1000) {
            return this.createMetricSet(labels.immutableCopy());
        }
        return null;
    }

    @Nonnull
    private MetricSet createMetricSet(Labels.Immutable labelsCopy) {
        MetricSet metricSet = new MetricSet(labelsCopy);
        MetricSet racyMetricSet = this.metricSets1.putIfAbsent(labelsCopy, metricSet);
        if (racyMetricSet != null) {
            metricSet = racyMetricSet;
        }
        this.metricSets2.putIfAbsent(labelsCopy, new MetricSet(labelsCopy, metricSet.getGauges()));
        if (this.metricSets1.size() >= 1000) {
            logger.warn("The limit of 1000 timers has been reached, no new timers will be created. Try to name your transactions so that there are less distinct transaction names.");
        }
        return (MetricSet)this.activeMetricSets.get(labelsCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementCounter(String name, Labels labels) {
        long criticalValueAtEnter = this.phaser.writerCriticalSectionEnter();
        try {
            MetricSet metricSet = this.getOrCreateMetricSet(labels);
            if (metricSet != null) {
                metricSet.incrementCounter(name);
            }
        }
        finally {
            this.phaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    public long writerCriticalSectionEnter() {
        return this.phaser.writerCriticalSectionEnter();
    }

    public void writerCriticalSectionExit(long criticalValueAtEnter) {
        this.phaser.writerCriticalSectionExit(criticalValueAtEnter);
    }

    public void removeGauge(String metricName, Labels labels) {
        MetricSet metricSet = (MetricSet)this.activeMetricSets.get(labels);
        if (metricSet != null) {
            metricSet.getGauges().remove(metricName);
        }
    }

    public static interface MetricsReporter {
        public void report(Map<? extends Labels, MetricSet> var1);
    }
}

