/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.metrics;

import co.elastic.apm.agent.objectpool.Recyclable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public interface Labels {
    public static final Labels EMPTY = Immutable.empty();

    @Nullable
    public String getServiceName();

    @Nullable
    public String getServiceVersion();

    @Nullable
    public CharSequence getTransactionName();

    @Nullable
    public String getTransactionType();

    @Nullable
    public String getSpanType();

    @Nullable
    public String getSpanSubType();

    public List<String> getKeys();

    public List<CharSequence> getValues();

    public boolean isEmpty();

    public int size();

    public String getKey(int var1);

    public CharSequence getValue(int var1);

    public Immutable immutableCopy();

    public static class Immutable
    extends AbstractBase {
        private static final Immutable EMPTY = new Mutable().immutableCopy();
        private final int hash;
        @Nullable
        private final String serviceName;
        @Nullable
        private final String serviceVersion;
        @Nullable
        private final String transactionName;
        @Nullable
        private final String transactionType;
        @Nullable
        private final String spanType;
        @Nullable
        private final String spanSubType;

        public Immutable(Labels labels) {
            super(new ArrayList<String>(labels.getKeys()), Immutable.copy(labels.getValues()));
            this.serviceName = labels.getServiceName();
            this.serviceVersion = labels.getServiceVersion();
            CharSequence transactionName = labels.getTransactionName();
            this.transactionName = transactionName != null ? transactionName.toString() : null;
            this.transactionType = labels.getTransactionType();
            this.spanType = labels.getSpanType();
            this.spanSubType = labels.getSpanSubType();
            this.hash = labels.hashCode();
        }

        private static List<CharSequence> copy(List<CharSequence> values) {
            ArrayList<CharSequence> immutableValues = new ArrayList<CharSequence>(values.size());
            for (int i = 0; i < values.size(); ++i) {
                immutableValues.add(values.get(i).toString());
            }
            return immutableValues;
        }

        public static Immutable empty() {
            return EMPTY;
        }

        @Override
        public int hashCode() {
            return this.hash;
        }

        @Override
        @Nullable
        public String getServiceName() {
            return this.serviceName;
        }

        @Override
        @Nullable
        public String getServiceVersion() {
            return this.serviceVersion;
        }

        @Override
        @Nullable
        public String getTransactionName() {
            return this.transactionName;
        }

        @Override
        @Nullable
        public String getTransactionType() {
            return this.transactionType;
        }

        @Override
        @Nullable
        public String getSpanType() {
            return this.spanType;
        }

        @Override
        @Nullable
        public String getSpanSubType() {
            return this.spanSubType;
        }

        @Override
        public Immutable immutableCopy() {
            return this;
        }
    }

    public static class Mutable
    extends AbstractBase
    implements Recyclable {
        @Nullable
        private String serviceName;
        @Nullable
        private String serviceVersion;
        @Nullable
        private CharSequence transactionName;
        @Nullable
        private String transactionType;
        @Nullable
        private String spanType;
        @Nullable
        private String spanSubType;

        private Mutable() {
            super(new ArrayList<String>(), new ArrayList<CharSequence>());
        }

        public static Mutable of() {
            return new Mutable();
        }

        public static Mutable of(String key, CharSequence value) {
            Mutable labels = new Mutable();
            labels.add(key, value);
            return labels;
        }

        public static Mutable of(Map<String, ? extends CharSequence> labelMap) {
            Mutable labels = new Mutable();
            for (Map.Entry<String, ? extends CharSequence> entry : labelMap.entrySet()) {
                labels.add(entry.getKey(), entry.getValue());
            }
            return labels;
        }

        public Labels add(String key, CharSequence value) {
            this.keys.add(key);
            this.values.add(value);
            return this;
        }

        public Mutable serviceName(@Nullable String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Mutable serviceVersion(@Nullable String serviceVersion) {
            this.serviceVersion = serviceVersion;
            return this;
        }

        public Mutable transactionName(@Nullable CharSequence transactionName) {
            this.transactionName = transactionName;
            return this;
        }

        public Mutable transactionType(@Nullable String transactionType) {
            this.transactionType = transactionType;
            return this;
        }

        public Mutable spanType(@Nullable String spanType) {
            this.spanType = spanType;
            return this;
        }

        public Mutable spanSubType(@Nullable String subtype) {
            this.spanSubType = subtype;
            return this;
        }

        @Override
        @Nullable
        public String getServiceName() {
            return this.serviceName;
        }

        @Override
        @Nullable
        public String getServiceVersion() {
            return this.serviceVersion;
        }

        @Override
        @Nullable
        public CharSequence getTransactionName() {
            return this.transactionName;
        }

        @Override
        @Nullable
        public String getTransactionType() {
            return this.transactionType;
        }

        @Override
        @Nullable
        public String getSpanType() {
            return this.spanType;
        }

        @Override
        @Nullable
        public String getSpanSubType() {
            return this.spanSubType;
        }

        @Override
        public Immutable immutableCopy() {
            return new Immutable(this);
        }

        @Override
        public void resetState() {
            this.keys.clear();
            this.values.clear();
            this.serviceName = null;
            this.serviceVersion = null;
            this.transactionName = null;
            this.transactionType = null;
            this.spanType = null;
            this.spanSubType = null;
        }
    }

    public static abstract class AbstractBase
    implements Labels {
        protected final List<String> keys;
        protected final List<CharSequence> values;

        AbstractBase(List<String> keys, List<CharSequence> values) {
            this.keys = keys;
            this.values = values;
        }

        @Override
        public List<String> getKeys() {
            return this.keys;
        }

        @Override
        public List<CharSequence> getValues() {
            return this.values;
        }

        @Override
        public boolean isEmpty() {
            return this.keys.isEmpty() && this.getServiceName() == null && this.getServiceVersion() == null && this.getTransactionName() == null && this.getTransactionType() == null && this.getSpanType() == null;
        }

        @Override
        public int size() {
            return this.keys.size();
        }

        @Override
        public String getKey(int i) {
            return this.keys.get(i);
        }

        @Override
        public CharSequence getValue(int i) {
            return this.values.get(i);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Labels)) {
                return false;
            }
            AbstractBase labels = (AbstractBase)o;
            return Objects.equals(this.getSpanType(), labels.getSpanType()) && Objects.equals(this.getSpanSubType(), labels.getSpanSubType()) && Objects.equals(this.getTransactionType(), labels.getTransactionType()) && AbstractBase.contentEquals(this.getTransactionName(), labels.getTransactionName()) && Objects.equals(this.getServiceName(), labels.getServiceName()) && Objects.equals(this.getServiceVersion(), labels.getServiceVersion()) && this.keys.equals(labels.keys) && AbstractBase.isEqual(this.values, labels.values);
        }

        public int hashCode() {
            int h = 0;
            for (int i = 0; i < this.values.size(); ++i) {
                h = 31 * h + this.hashEntryAt(i);
            }
            h = 31 * h + AbstractBase.hash(this.getServiceName());
            h = 31 * h + AbstractBase.hash(this.getServiceVersion());
            h = 31 * h + AbstractBase.hash(this.getTransactionName());
            h = 31 * h + (this.getTransactionType() != null ? this.getTransactionType().hashCode() : 0);
            h = 31 * h + (this.getSpanType() != null ? this.getSpanType().hashCode() : 0);
            h = 31 * h + (this.getSpanSubType() != null ? this.getSpanSubType().hashCode() : 0);
            return h;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.keys.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.keys.get(i)).append("=").append(this.values.get(i));
            }
            return sb.toString();
        }

        private int hashEntryAt(int i) {
            return this.keys.get(i).hashCode() * 31 + AbstractBase.hash(this.values.get(i));
        }

        private static boolean isEqual(List<CharSequence> values, List<CharSequence> otherValues) {
            if (values.size() != otherValues.size()) {
                return false;
            }
            for (int i = 0; i < values.size(); ++i) {
                if (AbstractBase.contentEquals(values.get(i), otherValues.get(i))) continue;
                return false;
            }
            return true;
        }

        private static boolean contentEquals(@Nullable CharSequence cs1, @Nullable CharSequence cs2) {
            if (cs1 == null || cs2 == null) {
                return cs1 == cs2;
            }
            if (cs1 instanceof String) {
                return ((String)cs1).contentEquals(cs2);
            }
            if (cs2 instanceof String) {
                return ((String)cs2).contentEquals(cs1);
            }
            if (cs1.length() == cs2.length()) {
                for (int i = 0; i < cs1.length(); ++i) {
                    if (cs1.charAt(i) == cs2.charAt(i)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        static int hash(@Nullable CharSequence cs) {
            if (cs == null) {
                return 0;
            }
            if (cs instanceof String) {
                return cs.hashCode();
            }
            int h = 0;
            for (int i = 0; i < cs.length(); ++i) {
                h = 31 * h + cs.charAt(i);
            }
            return h;
        }
    }
}

