/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.loginstr.reformatting;

import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;

public class Utils {
    private static final String ECS_JSON_FILE_EXTENSION = ".ecs.json";

    public static String computeLogReformattingFilePath(String originalLogFile, @Nullable String configuredReformattingDestinationDir) {
        Path originalFilePath = Paths.get(originalLogFile, new String[0]);
        Path logFileName = Paths.get(Utils.replaceFileExtensionToEcsJson(originalFilePath.getFileName().toString()), new String[0]);
        Path reformattingDir = Utils.computeLogReformattingDir(originalFilePath, configuredReformattingDestinationDir);
        if (reformattingDir != null) {
            logFileName = reformattingDir.resolve(logFileName);
        }
        return logFileName.toString();
    }

    @Nullable
    public static Path computeLogReformattingDir(Path originalFilePath, @Nullable String configuredReformattingDestinationDir) {
        Path ecsDir;
        Path logsDir = originalFilePath.getParent();
        if (configuredReformattingDestinationDir == null) {
            ecsDir = logsDir;
        } else {
            ecsDir = Paths.get(configuredReformattingDestinationDir, new String[0]);
            if (!ecsDir.isAbsolute() && logsDir != null) {
                ecsDir = logsDir.resolve(ecsDir);
            }
        }
        return ecsDir;
    }

    public static String replaceFileExtensionToEcsJson(String originalFileName) {
        int extensionIndex = originalFileName.lastIndexOf(46);
        if (extensionIndex > 0) {
            originalFileName = originalFileName.substring(0, extensionIndex);
        }
        return originalFileName.concat(ECS_JSON_FILE_EXTENSION);
    }
}

