/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.loginstr.correlation;

import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.Tracer;
import co.elastic.apm.agent.impl.error.ErrorCapture;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.sdk.state.CallDepth;
import co.elastic.apm.agent.sdk.state.GlobalState;

@GlobalState
public abstract class AbstractLogCorrelationHelper {
    public static final String TRACE_ID_MDC_KEY = "trace.id";
    public static final String TRANSACTION_ID_MDC_KEY = "transaction.id";
    public static final String ERROR_ID_MDC_KEY = "error.id";
    private static final CallDepth callDepth = CallDepth.get(AbstractLogCorrelationHelper.class);

    public boolean beforeLoggingEvent() {
        if (callDepth.isNestedCallAndIncrement()) {
            return false;
        }
        return this.addToMdc();
    }

    public void afterLoggingEvent(boolean addedToMdc) {
        if (!callDepth.isNestedCallAndDecrement() && addedToMdc) {
            this.removeFromMdc();
        }
    }

    protected abstract boolean addToMdc();

    protected abstract void removeFromMdc();

    public static abstract class DefaultLogCorrelationHelper
    extends AbstractLogCorrelationHelper {
        private final Tracer tracer = GlobalTracer.get();

        @Override
        protected boolean addToMdc() {
            ErrorCapture activeError;
            boolean addedToMdc = false;
            AbstractSpan<?> activeSpan = this.tracer.getActive();
            if (activeSpan != null) {
                this.addToMdc(AbstractLogCorrelationHelper.TRACE_ID_MDC_KEY, activeSpan.getTraceContext().getTraceId().toString());
                this.addToMdc(AbstractLogCorrelationHelper.TRANSACTION_ID_MDC_KEY, activeSpan.getTraceContext().getTransactionId().toString());
                addedToMdc = true;
            }
            if ((activeError = ErrorCapture.getActive()) != null) {
                this.addToMdc(AbstractLogCorrelationHelper.ERROR_ID_MDC_KEY, activeError.getTraceContext().getId().toString());
                addedToMdc = true;
            }
            return addedToMdc;
        }

        @Override
        protected void removeFromMdc() {
            this.removeFromMdc(AbstractLogCorrelationHelper.TRACE_ID_MDC_KEY);
            this.removeFromMdc(AbstractLogCorrelationHelper.TRANSACTION_ID_MDC_KEY);
            this.removeFromMdc(AbstractLogCorrelationHelper.ERROR_ID_MDC_KEY);
        }

        protected abstract void addToMdc(String var1, String var2);

        protected abstract void removeFromMdc(String var1);
    }
}

