/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.logging;

import co.elastic.apm.agent.logging.Log4j2LoggerBridge;
import co.elastic.apm.agent.sdk.logging.ILoggerFactory;
import co.elastic.apm.agent.sdk.logging.Logger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.spi.AbstractLoggerAdapter;
import org.apache.logging.log4j.spi.LoggerContext;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.util.StackLocatorUtil;

public class Log4jLoggerFactoryBridge
extends AbstractLoggerAdapter<Logger>
implements ILoggerFactory {
    private static final String LOGGER_FACTORY = "co.elastic.apm.agent.sdk.logging.LoggerFactory";

    public static void shutdown() {
        LoggerContextFactory factory = LogManager.getFactory();
        if (factory instanceof Log4jContextFactory) {
            for (LoggerContext loggerContext : ((Log4jContextFactory)factory).getSelector().getLoggerContexts()) {
                LogManager.shutdown(loggerContext);
            }
        }
    }

    @Override
    protected Logger newLogger(String name, LoggerContext context) {
        String key = "ROOT".equals(name) ? "" : name;
        return new Log4j2LoggerBridge(context.getLogger(key), name);
    }

    @Override
    protected LoggerContext getContext() {
        Class<?> factoryCaller = StackLocatorUtil.getCallerClass(LOGGER_FACTORY);
        if (factoryCaller == null) {
            return LogManager.getContext();
        }
        return this.getContext(factoryCaller);
    }
}

