/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.logback.reformatting;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import co.elastic.apm.agent.logback.reformatting.VersionUtils;
import co.elastic.apm.agent.loginstr.reformatting.AbstractEcsReformattingHelper;
import co.elastic.apm.agent.loginstr.reformatting.Utils;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.logging.AdditionalField;
import co.elastic.logging.logback.EcsEncoder;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

class LogbackEcsReformattingHelper
extends AbstractEcsReformattingHelper<OutputStreamAppender<ILoggingEvent>, Encoder<ILoggingEvent>> {
    private static final Logger logger = LoggerFactory.getLogger(LogbackEcsReformattingHelper.class);
    private static final LoggerContext defaultLoggerContext = new LoggerContext();

    LogbackEcsReformattingHelper() {
    }

    @Override
    @Nullable
    protected Encoder<ILoggingEvent> getFormatterFrom(OutputStreamAppender<ILoggingEvent> appender) {
        return appender.getEncoder();
    }

    @Override
    protected void setFormatter(OutputStreamAppender<ILoggingEvent> appender, Encoder<ILoggingEvent> encoder) {
        if (encoder instanceof EcsEncoder) {
            ((EcsEncoder)encoder).init(appender.getOutputStream());
        }
        appender.setEncoder(encoder);
    }

    @Override
    protected boolean isAllowedFormatter(Encoder<ILoggingEvent> formatter, List<WildcardMatcher> allowList) {
        if (formatter instanceof LayoutWrappingEncoder) {
            return WildcardMatcher.anyMatch(allowList, ((LayoutWrappingEncoder)formatter).getLayout().getClass().getName()) != null;
        }
        return super.isAllowedFormatter(formatter, allowList);
    }

    @Override
    protected String getAppenderName(OutputStreamAppender<ILoggingEvent> appender) {
        return appender.getName();
    }

    @Override
    protected Encoder<ILoggingEvent> createEcsFormatter(String eventDataset, @Nullable String serviceName, @Nullable String serviceVersion, @Nullable String serviceNodeName, @Nullable Map<String, String> additionalFields, Encoder<ILoggingEvent> originalFormatter) {
        EcsEncoder ecsEncoder = new EcsEncoder();
        ecsEncoder.setServiceName(serviceName);
        ecsEncoder.setServiceVersion(serviceVersion);
        ecsEncoder.setServiceNodeName(serviceNodeName);
        ecsEncoder.setEventDataset(eventDataset);
        ecsEncoder.setIncludeMarkers(true);
        ecsEncoder.setIncludeOrigin(false);
        ecsEncoder.setStackTraceAsArray(false);
        if (additionalFields != null) {
            for (Map.Entry<String, String> keyValuePair : additionalFields.entrySet()) {
                ecsEncoder.addAdditionalField(new AdditionalField(keyValuePair.getKey(), keyValuePair.getValue()));
            }
        }
        return ecsEncoder;
    }

    @Override
    @Nullable
    protected OutputStreamAppender<ILoggingEvent> createAndStartEcsAppender(OutputStreamAppender<ILoggingEvent> originalAppender, String ecsAppenderName, Encoder<ILoggingEvent> ecsEncoder) {
        RollingFileAppender ecsAppender = null;
        if (originalAppender instanceof FileAppender) {
            FileAppender fileAppender = (FileAppender)originalAppender;
            ecsAppender = new RollingFileAppender();
            ecsAppender.setEncoder(ecsEncoder);
            String ecsFile = Utils.computeLogReformattingFilePath(fileAppender.getFile(), this.getConfiguredReformattingDir());
            ecsAppender.setFile(ecsFile);
            FixedWindowRollingPolicy rollingPolicy = new FixedWindowRollingPolicy();
            rollingPolicy.setMinIndex(1);
            rollingPolicy.setMaxIndex(1);
            rollingPolicy.setFileNamePattern(ecsFile + ".%i");
            rollingPolicy.setParent((FileAppender)ecsAppender);
            rollingPolicy.setContext((Context)defaultLoggerContext);
            rollingPolicy.start();
            ecsAppender.setRollingPolicy((RollingPolicy)rollingPolicy);
            SizeBasedTriggeringPolicy triggeringPolicy = new SizeBasedTriggeringPolicy();
            try {
                VersionUtils.setMaxFileSize(triggeringPolicy, this.getMaxLogFileSize());
            }
            catch (Throwable throwable) {
                logger.info("Failed to set max file size for log ECS-reformatting file-rolling strategy. Using the default Logback setting instead - 10485760. Error message: " + throwable.getMessage());
            }
            triggeringPolicy.setContext((Context)defaultLoggerContext);
            triggeringPolicy.start();
            ecsAppender.setTriggeringPolicy((TriggeringPolicy)triggeringPolicy);
            ecsAppender.setContext((Context)defaultLoggerContext);
            try {
                VersionUtils.copyImmediateFlushSetting(originalAppender, ecsAppender);
            }
            catch (Throwable throwable) {
                logger.info("Failed to set immediate-flush for the custom ECS appender");
            }
            ecsAppender.setAppend(true);
            ecsAppender.setName(ecsAppenderName);
            ecsAppender.start();
        }
        return ecsAppender;
    }

    @Override
    protected void closeShadeAppender(OutputStreamAppender<ILoggingEvent> shadeAppender) {
        shadeAppender.stop();
    }
}

