/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.log4j2.reformatting;

import co.elastic.apm.agent.log4j2.reformatting.Log4J2EcsReformattingHelper;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;

public class Log4j2AppenderGetLayoutAdvice {
    private static final Log4J2EcsReformattingHelper helper = new Log4J2EcsReformattingHelper();

    @Nullable
    @Advice.AssignReturned.ToReturned
    @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class, inline=false)
    public static Layout<?> reformatLoggingEvent(@Advice.This(typing=Assigner.Typing.DYNAMIC) Appender thisAppender, @Advice.Return @Nullable Layout<?> originalLayout) {
        if (originalLayout == null) {
            return null;
        }
        Layout ecsLayout = (Layout)helper.getEcsOverridingFormatterFor(thisAppender);
        if (ecsLayout != null) {
            return ecsLayout;
        }
        return originalLayout;
    }
}

