/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.log4j2.correlation;

import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.Tracer;
import co.elastic.apm.agent.impl.error.ErrorCapture;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

class CorrelationIdMapAdapter
extends AbstractMap<String, String> {
    private static final CorrelationIdMapAdapter INSTANCE = new CorrelationIdMapAdapter();
    private static final Set<Map.Entry<String, String>> ENTRY_SET = new TraceIdentifierEntrySet();
    private static final List<String> ALL_KEYS = Arrays.asList("trace.id", "transaction.id", "error.id");
    private static final Tracer tracer = GlobalTracer.get();
    private static final List<Map.Entry<String, String>> ENTRIES = Arrays.asList(new LazyEntry("trace.id", new Callable<String>(){

        @Override
        @Nullable
        public String call() {
            AbstractSpan<?> activeSpan = tracer.getActive();
            if (activeSpan == null) {
                return null;
            }
            return activeSpan.getTraceContext().getTraceId().toString();
        }
    }), new LazyEntry("transaction.id", new Callable<String>(){

        @Override
        @Nullable
        public String call() {
            AbstractSpan<?> activeSpan = tracer.getActive();
            if (activeSpan == null) {
                return null;
            }
            return activeSpan.getTraceContext().getTransactionId().toString();
        }
    }), new LazyEntry("error.id", new Callable<String>(){

        @Override
        @Nullable
        public String call() {
            ErrorCapture error = ErrorCapture.getActive();
            if (error == null) {
                return null;
            }
            return error.getTraceContext().getId().toString();
        }
    }));

    public static Map<String, String> get() {
        return INSTANCE;
    }

    public static Iterable<String> allKeys() {
        return ALL_KEYS;
    }

    private CorrelationIdMapAdapter() {
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return ENTRY_SET;
    }

    private static class LazyEntry
    implements Map.Entry<String, String> {
        private final String key;
        private final Callable<String> valueSupplier;

        private LazyEntry(String key, Callable<String> valueSupplier) {
            this.key = key;
            this.valueSupplier = valueSupplier;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            try {
                return this.valueSupplier.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String setValue(String value) {
            throw new UnsupportedOperationException();
        }
    }

    private static class TraceIdentifierEntrySet
    extends AbstractSet<Map.Entry<String, String>> {
        private TraceIdentifierEntrySet() {
        }

        @Override
        public int size() {
            int size = 0;
            for (Map.Entry<String, String> ignored : this) {
                ++size;
            }
            return size;
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return new Iterator<Map.Entry<String, String>>(){
                private int i = 0;
                @Nullable
                private Map.Entry<String, String> next = this.findNext();

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }

                @Override
                public Map.Entry<String, String> next() {
                    if (this.next != null) {
                        try {
                            Map.Entry<String, String> entry = this.next;
                            return entry;
                        }
                        finally {
                            this.next = this.findNext();
                        }
                    }
                    throw new NoSuchElementException();
                }

                @Nullable
                private Map.Entry<String, String> findNext() {
                    Map.Entry next = null;
                    while (next == null && this.i < ENTRIES.size()) {
                        next = (Map.Entry)ENTRIES.get(this.i++);
                        if (next.getValue() != null) continue;
                        next = null;
                    }
                    return next;
                }
            };
        }
    }
}

