/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.log4j1.reformatting;

import co.elastic.apm.agent.loginstr.reformatting.AbstractEcsReformattingHelper;
import co.elastic.apm.agent.loginstr.reformatting.Utils;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.logging.log4j.EcsLayout;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.WriterAppender;

class Log4J1EcsReformattingHelper
extends AbstractEcsReformattingHelper<WriterAppender, Layout> {
    private static final Logger logger = LoggerFactory.getLogger(Log4J1EcsReformattingHelper.class);

    Log4J1EcsReformattingHelper() {
    }

    @Override
    @Nullable
    protected Layout getFormatterFrom(WriterAppender appender) {
        return appender.getLayout();
    }

    @Override
    protected void setFormatter(WriterAppender appender, Layout layout) {
        appender.setLayout(layout);
    }

    @Override
    protected String getAppenderName(WriterAppender appender) {
        return appender.getName();
    }

    @Override
    protected Layout createEcsFormatter(String eventDataset, @Nullable String serviceName, @Nullable String serviceVersion, @Nullable String serviceNodeName, @Nullable Map<String, String> additionalFields, Layout originalFormatter) {
        EcsLayout ecsLayout = new EcsLayout();
        ecsLayout.setServiceName(serviceName);
        ecsLayout.setServiceVersion(serviceVersion);
        ecsLayout.setServiceNodeName(serviceNodeName);
        ecsLayout.setEventDataset(eventDataset);
        if (additionalFields != null) {
            for (Map.Entry<String, String> keyValuePair : additionalFields.entrySet()) {
                ecsLayout.setAdditionalField(keyValuePair.getKey() + "=" + keyValuePair.getValue());
            }
        }
        ecsLayout.setIncludeOrigin(false);
        ecsLayout.setStackTraceAsArray(false);
        return ecsLayout;
    }

    @Override
    @Nullable
    protected WriterAppender createAndStartEcsAppender(WriterAppender originalAppender, String ecsAppenderName, Layout ecsLayout) {
        RollingFileAppender shadeAppender = null;
        if (originalAppender instanceof FileAppender) {
            try {
                FileAppender fileAppender = (FileAppender)originalAppender;
                String reformattedFile = Utils.computeLogReformattingFilePath(fileAppender.getFile(), this.getConfiguredReformattingDir());
                shadeAppender = new RollingFileAppender(ecsLayout, reformattedFile, true);
                shadeAppender.setMaxBackupIndex(1);
                shadeAppender.setMaximumFileSize(this.getMaxLogFileSize());
                shadeAppender.setImmediateFlush(originalAppender.getImmediateFlush());
                shadeAppender.setName(ecsAppenderName);
                shadeAppender.setLayout(ecsLayout);
            }
            catch (IOException e) {
                logger.error("Failed to create Log shading FileAppender. Auto ECS reformatting will not work.", e);
            }
        }
        return shadeAppender;
    }

    @Override
    protected void closeShadeAppender(WriterAppender shadeAppender) {
        shadeAppender.close();
    }
}

