/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.log4j1.correlation;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.log4j1.correlation.Log4j1LogCorrelationHelper;
import java.util.Collection;
import java.util.Collections;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class Log4j1LogCorrelationInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singleton("log4j1-correlation");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("org.apache.log4j.Category");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("callAppenders").and(ElementMatchers.takesArguments(1)).and(ElementMatchers.takesArgument(0, ElementMatchers.named("org.apache.log4j.spi.LoggingEvent")));
    }

    public static class AdviceClass {
        private static final Log4j1LogCorrelationHelper helper = new Log4j1LogCorrelationHelper();

        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static boolean addToMdc() {
            return helper.beforeLoggingEvent();
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void removeFromMdc(@Advice.Enter boolean addedToMdc) {
            helper.afterLoggingEvent(addedToMdc);
        }
    }
}

