/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.log.shipper;

import co.elastic.apm.agent.common.ThreadUtils;
import co.elastic.apm.agent.context.AbstractLifecycleListener;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.agent.log.shipper.ApmServerLogShipper;
import co.elastic.apm.agent.log.shipper.FileTailer;
import co.elastic.apm.agent.log.shipper.TailableFile;
import co.elastic.apm.agent.logging.Log4j2ConfigurationFactory;
import co.elastic.apm.agent.logging.LogFormat;
import co.elastic.apm.agent.logging.LoggingConfiguration;
import co.elastic.apm.agent.report.ApmServerClient;
import co.elastic.apm.agent.report.ReporterConfiguration;
import co.elastic.apm.agent.report.serialize.DslJsonSerializer;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.util.ExecutorUtils;
import java.io.File;
import java.io.IOException;

public class LogShipperFactory
extends AbstractLifecycleListener {
    private static final Logger logger = LoggerFactory.getLogger(LogShipperFactory.class);
    private static final int SHUTDOWN_TIMEOUT = 5000;
    private static final int BUFFER_SIZE = 4096;
    private static final int MAX_LINES_PER_CYCLE = 100;
    private static final int IDLE_TIME_MS = 250;
    private final FileTailer fileTailer;

    public LogShipperFactory(ElasticApmTracer tracer) {
        ApmServerClient apmServerClient = tracer.getApmServerClient();
        DslJsonSerializer serializer = new DslJsonSerializer(tracer.getConfig(StacktraceConfiguration.class), apmServerClient, tracer.getMetaDataFuture());
        ApmServerLogShipper logShipper = new ApmServerLogShipper(apmServerClient, tracer.getConfig(ReporterConfiguration.class), serializer);
        ExecutorUtils.SingleNamedThreadFactory threadFactory = new ExecutorUtils.SingleNamedThreadFactory(ThreadUtils.addElasticApmThreadPrefix("log-shipper"));
        this.fileTailer = new FileTailer(logShipper, 4096, 100, 250L, threadFactory);
    }

    @Override
    public void start(ElasticApmTracer tracer) throws IOException {
        LoggingConfiguration config = tracer.getConfig(LoggingConfiguration.class);
        String logFile = config.getLogFile();
        if (!config.isShipAgentLogs()) {
            return;
        }
        if (!tracer.getApmServerClient().supportsLogsEndpoint()) {
            logger.warn("This version of APM Server does not support the logs endpoint. Consider updating to version 7.9+.");
            return;
        }
        if (logFile.equals("System.out")) {
            TailableFile tailableFile = this.fileTailer.tailFile(Log4j2ConfigurationFactory.getTempLogFile(tracer.getEphemeralId()));
            logger.debug("Tailing temp agent log file {}", (Object)tailableFile);
            tailableFile.deleteStateFileOnExit();
            this.fileTailer.start();
        } else if (config.getLogFormatFile() == LogFormat.JSON) {
            this.fileTailer.tailFile(new File(logFile));
            logger.debug("Tailing agent log file {}", (Object)logFile);
            this.fileTailer.start();
        } else {
            logger.warn("Can't ship agent log file if format is plain text. Set {}={}", (Object)"log_format_file", (Object)LogFormat.JSON);
        }
    }

    @Override
    public void stop() throws Exception {
        this.fileTailer.stop(5000L);
    }
}

