/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.lettuce;

import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.lettuce.Lettuce34Instrumentation;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import com.lambdaworks.redis.protocol.RedisCommand;
import java.util.Arrays;
import java.util.Collection;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class Lettuce34StopSpanInstrumentation
extends Lettuce34Instrumentation {
    private static final Logger logger = LoggerFactory.getLogger(Lettuce34StopSpanInstrumentation.class);

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameStartsWith("com.lambdaworks.redis").and(ElementMatchers.nameContains("Command"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("com.lambdaworks.redis.protocol.RedisCommand")).and(ElementMatchers.declaresMethod(ElementMatchers.named("getType")));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("redis", "lettuce");
    }

    public static class OnCancel
    extends Lettuce34StopSpanInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("cancel").and(ElementMatchers.takesArguments(0));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void beforeComplete(@Advice.This RedisCommand<?, ?, ?> command) {
                Span span = Lettuce34Instrumentation.commandToSpan.remove(command);
                if (span != null) {
                    logger.debug("Command#cancel");
                    span.end();
                }
            }
        }
    }

    public static class OnCompleteExceptionally
    extends Lettuce34StopSpanInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("completeExceptionally").and(ElementMatchers.takesArguments(Throwable.class));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void beforeComplete(@Advice.This RedisCommand<?, ?, ?> command, @Advice.Argument(value=0) Throwable throwable) {
                Span span = Lettuce34Instrumentation.commandToSpan.remove(command);
                if (span != null) {
                    logger.debug("Command#completeExceptionally");
                    ((Span)span.captureException(throwable)).end();
                }
            }
        }
    }

    public static class OnComplete
    extends Lettuce34StopSpanInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("complete").and(ElementMatchers.takesArguments(0));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void beforeComplete(@Advice.This RedisCommand<?, ?, ?> command) {
                Span span = Lettuce34Instrumentation.commandToSpan.remove(command);
                if (span != null) {
                    logger.debug("Command#complete");
                    span.end();
                }
            }
        }
    }
}

