/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.kafka.helper;

import co.elastic.apm.agent.impl.transaction.BinaryHeaderGetter;
import co.elastic.apm.agent.impl.transaction.BinaryHeaderSetter;
import co.elastic.apm.agent.impl.transaction.HeaderGetter;
import co.elastic.apm.agent.impl.transaction.HeaderRemover;
import co.elastic.apm.agent.kafka.helper.ElasticHeaderImpl;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Header;

public class KafkaRecordHeaderAccessor
implements BinaryHeaderGetter<ConsumerRecord>,
BinaryHeaderSetter<ProducerRecord>,
HeaderRemover<ProducerRecord> {
    public static final Logger logger = LoggerFactory.getLogger(KafkaRecordHeaderAccessor.class);
    private static final KafkaRecordHeaderAccessor INSTANCE = new KafkaRecordHeaderAccessor();
    private static final ThreadLocal<Map<String, ElasticHeaderImpl>> threadLocalHeaderMap = new ThreadLocal();

    public static KafkaRecordHeaderAccessor instance() {
        return INSTANCE;
    }

    @Override
    @Nullable
    public byte[] getFirstHeader(String headerName, ConsumerRecord record) {
        Header traceParentHeader = record.headers().lastHeader(headerName);
        if (traceParentHeader != null) {
            return traceParentHeader.value();
        }
        return null;
    }

    @Override
    public <S> void forEach(String headerName, ConsumerRecord carrier, S state, HeaderGetter.HeaderConsumer<byte[], S> consumer) {
        for (Header header : carrier.headers().headers(headerName)) {
            consumer.accept(header.value(), state);
        }
    }

    @Override
    @Nullable
    public byte[] getFixedLengthByteArray(String headerName, int length) {
        ElasticHeaderImpl header;
        Map<String, ElasticHeaderImpl> headerMap = threadLocalHeaderMap.get();
        if (headerMap == null) {
            headerMap = new HashMap<String, ElasticHeaderImpl>();
            threadLocalHeaderMap.set(headerMap);
        }
        if ((header = headerMap.get(headerName)) == null) {
            header = new ElasticHeaderImpl(headerName, length);
            headerMap.put(headerName, header);
        }
        return header.valueForSetting();
    }

    @Override
    public void setHeader(String headerName, byte[] headerValue, ProducerRecord record) {
        ElasticHeaderImpl header = null;
        Map<String, ElasticHeaderImpl> headerMap = threadLocalHeaderMap.get();
        if (headerMap != null) {
            header = headerMap.get(headerName);
        }
        if (header == null || header.value == null) {
            logger.warn("No header cached for {}, allocating byte array for each record", (Object)headerName);
            record.headers().add(headerName, headerValue);
        } else {
            record.headers().add((Header)header);
        }
    }

    @Override
    public void remove(String headerName, ProducerRecord carrier) {
        carrier.headers().remove(headerName);
    }
}

