/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.kafka;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.kafka.KafkaConsumerInstrumentation;
import co.elastic.apm.agent.kafka.helper.KafkaInstrumentationHeadersHelper;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.matcher.ElementMatcher;
import org.apache.kafka.clients.consumer.ConsumerRecords;

public class NewKafkaPollExitInstrumentation
extends KafkaConsumerInstrumentation {
    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return super.getClassLoaderMatcher().and(CustomElementMatchers.classLoaderCanLoadClass("org.apache.kafka.common.header.Headers"));
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.kafka.NewKafkaPollExitInstrumentation$KafkaPollExitAdvice";
    }

    public static class KafkaPollExitAdvice {
        private static final KafkaInstrumentationHeadersHelper helper = KafkaInstrumentationHeadersHelper.get();

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class, inline=false)
        public static void pollEnd(@Advice.Thrown Throwable throwable, @Advice.Return @Nullable ConsumerRecords<?, ?> records) {
            Span span = TracerAwareInstrumentation.tracer.getActiveSpan();
            if (span != null && span.getSubtype() != null && span.getSubtype().equals("kafka") && span.getAction() != null && span.getAction().equals("poll")) {
                helper.addSpanLinks(records, span);
                ((Span)((Span)span.captureException(throwable)).deactivate()).end();
            }
        }
    }
}

