/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.kafka;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.configuration.MessagingConfiguration;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.kafka.BaseKafkaInstrumentation;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class KafkaConsumerInstrumentation
extends BaseKafkaInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("org.apache.kafka.clients.consumer.KafkaConsumer");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("poll").and(ElementMatchers.isPublic());
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.kafka.KafkaConsumerInstrumentation$KafkaPollEntryAdvice";
    }

    public static class LegacyKafkaPollExitInstrumentation
    extends KafkaConsumerInstrumentation {
        @Override
        public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
            return super.getClassLoaderMatcher().and(ElementMatchers.not(CustomElementMatchers.classLoaderCanLoadClass("org.apache.kafka.common.header.Headers")));
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.kafka.KafkaConsumerInstrumentation$LegacyKafkaPollExitInstrumentation$KafkaPollExitAdvice";
        }

        public static class KafkaPollExitAdvice {
            @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class, inline=false)
            public static void pollEnd(@Advice.Thrown Throwable throwable) {
                Span span = TracerAwareInstrumentation.tracer.getActiveSpan();
                if (span != null && "kafka".equals(span.getSubtype()) && "poll".equals(span.getAction())) {
                    span.captureException(throwable);
                    ((Span)span.deactivate()).end();
                }
            }
        }
    }

    public static class KafkaPollEntryAdvice {
        private static final MessagingConfiguration messagingConfiguration = GlobalTracer.requireTracerImpl().getConfig(MessagingConfiguration.class);

        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static void pollStart() {
            Transaction transaction;
            AbstractSpan<?> activeSpan = TracerAwareInstrumentation.tracer.getActive();
            if (activeSpan == null) {
                return;
            }
            if (messagingConfiguration.shouldEndMessagingTransactionOnPoll() && activeSpan instanceof Transaction && "messaging".equals((transaction = (Transaction)activeSpan).getType())) {
                ((Transaction)transaction.deactivate()).end();
                return;
            }
            Span span = activeSpan.createExitSpan();
            if (span == null) {
                return;
            }
            ((Span)span.withType("messaging")).withSubtype("kafka").withAction("poll").withName("KafkaConsumer#poll", 100);
            span.getContext().getServiceTarget().withType("kafka");
            span.activate();
        }
    }
}

